% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smirnov.R
\name{smirnov}
\alias{smirnov}
\title{Smirnov (SV) Measure}
\usage{
smirnov(data)
}
\arguments{
\item{data}{A data.frame or a matrix with cases in rows and variables in columns.}
}
\value{
The function returns an object of the class "dist".
\cr
}
\description{
The function calculates a dissimilarity matrix based on the SV similarity measure.
}
\details{
The Smirnov similarity measure was presented in (Smirnov, 1968).
The measure assigns high similarity to matches when the frequency of the matching value is low, and the other values occur frequently, see (Borian et al., 2008).
}
\examples{
# sample data
data(data20)

# dissimilarity matrix calculation
prox.smirnov <- smirnov(data20)

}
\references{
Smirnov E.S. (1968). On exact methods in systematics. 
Systematic Zoology, 17(1), 1-13.
 \cr
 \cr
Boriah S., Chandola V., Kumar V. (2008). Similarity measures for categorical data: A comparative evaluation.
In: Proceedings of the 8th SIAM International Conference on Data Mining, SIAM, p. 243-254.
}
\seealso{
\code{\link[nomclust]{anderberg}},
\code{\link[nomclust]{burnaby}},
\code{\link[nomclust]{eskin}},
\code{\link[nomclust]{gambaryan}},
\code{\link[nomclust]{goodall1}},
\code{\link[nomclust]{goodall2}},
\code{\link[nomclust]{goodall3}},
\code{\link[nomclust]{goodall4}},
\code{\link[nomclust]{iof}},
\code{\link[nomclust]{lin}},
\code{\link[nomclust]{lin1}},
\code{\link[nomclust]{of}},
\code{\link[nomclust]{sm}},
\code{\link[nomclust]{ve}},
\code{\link[nomclust]{vm}}.
}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
