% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_address_lookup.R
\name{geo_address_lookup}
\alias{geo_address_lookup}
\title{Query the address and other details of one or multiple OSM objects}
\usage{
geo_address_lookup(
  osm_ids,
  type,
  lat = "lat",
  long = "lon",
  full_results = FALSE,
  return_addresses = TRUE,
  verbose = FALSE,
  custom_query = list()
)
}
\arguments{
\item{osm_ids}{vector of OSM identifiers (\code{c(00000, 11111, 22222)}).}

\item{type}{vector of the type of the OSM type associated to each \code{osm_ids}.
Possible values are node ("N"), way ("W") or relation ("R"). If a single
value is provided it would be recycled.#'}

\item{lat}{latitude column name (i.e. \code{"lat"}).}

\item{long}{longitude column name (i.e. \code{"long"}).}

\item{full_results}{returns all data from the geocoder service if TRUE.
If FALSE then only longitude and latitude are returned from the geocoder service.}

\item{return_addresses}{return input addresses with results if TRUE. Note that
most services return the input addresses with \code{full_results = TRUE} and setting
return_addresses to FALSE does not prevent this.}

\item{verbose}{if TRUE then detailed logs are output to the console}

\item{custom_query}{API-specific parameters to be used, passed as a named
list (i.e. \code{list(countrycodes = "US")}). See Details.}
}
\value{
A \code{tibble} with the results.
}
\description{
Geocodes addresses for OSM objects, identified with the OSM Id.
}
\details{
See \url{https://nominatim.org/release-docs/develop/api/Lookup/} for additional
parameters to be passed to \code{custom_query}.
}
\examples{
\dontshow{if (nominatim_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
ids <- geo_address_lookup(
  osm_ids = c(46240148, 34633854),
  type = c("W"),
)

ids
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other geocoding: 
\code{\link{geo_amenity}()},
\code{\link{geo_lite}()},
\code{\link{reverse_geo_lite}()}

Other lookup: 
\code{\link{geo_address_lookup_sf}()}
}
\concept{geocoding}
\concept{lookup}
