% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_info.R
\name{nomis_data_info}
\alias{nomis_data_info}
\title{Nomis data structures}
\usage{
nomis_data_info(id)
}
\arguments{
\item{id}{Dataset ID. If empty, returns data on all available datasets.
If the ID of a dataset, returns metadata for that particular dataset.}
}
\value{
A tibble with all available datasets and their metadata.
}
\description{
Retrieve metadata on the structure and available variables for all available
data sets or the information available in a specific dataset based on its ID.
}
\examples{
\donttest{

# Get info on all datasets
x <- nomis_data_info()

tibble::glimpse(x)

# Get info on a particular dataset
y <- nomis_data_info('NM_1658_1')

tibble::glimpse(y)

}
}
\seealso{
\code{\link{nomis_get_data}}

\code{\link{nomis_get_metadata}}

\code{\link{nomis_overview}}

\code{\link{nomis_codelist}}
}
