% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finitepop.R
\name{AllPossiblyObsH0_CONT}
\alias{AllPossiblyObsH0_CONT}
\title{Finite population sample space given an observed dataset.}
\usage{
AllPossiblyObsH0_CONT(n_y0x0z0, n_y1x0z0, n_y0x0z1, n_y1x0z1, n_y0x1z1,
  n_y1x1z1, findGLR = FALSE)
}
\arguments{
\item{n_y0x0z0}{Number of individuals with Y=0, X=0, Z=0.}

\item{n_y1x0z0}{Number of individuals with Y=1, X=0, Z=0.}

\item{n_y0x0z1}{Number of individuals with Y=0, X=0, Z=1.}

\item{n_y1x0z1}{Number of individuals with Y=1, X=0, Z=1.}

\item{n_y0x1z1}{Number of individuals with Y=0, X=1, Z=1.}

\item{n_y1x1z1}{Number of individuals with Y=1, X=1, Z=1.}

\item{findGLR}{Whether or not to find the generalized likelihood ratio
(GLR) test statistic for each possible observable dataset.}
}
\value{
All possibly observable datasets in a data.table format.
}
\description{
Sample space of all possibly observable datasets given an observed dataset,
   assuming only Compliers and Never Takers in the population.
}
\examples{
AllPossiblyObsH0_CONT(16, 1, 5, 1, 2, 8)
AllPossiblyObsH0_CONT(16, 1, 5, 1, 2, 8, findGLR=TRUE)
}

