% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_inference.R
\name{controlInf}
\alias{controlInf}
\title{Control parameters for inference}
\usage{
controlInf(
  vars_selection = FALSE,
  var_method = c("analytic", "bootstrap"),
  rep_type = c("auto", "JK1", "JKn", "BRR", "bootstrap", "subbootstrap", "mrbbootstrap",
    "Fay"),
  bias_inf = c("union", "div"),
  num_boot = 500,
  bias_correction = FALSE,
  alpha = 0.05,
  cores = 1,
  keep_boot,
  pmm_exact_se = FALSE,
  pi_ij
)
}
\arguments{
\item{vars_selection}{If \code{TRUE}, then variables selection model is used.}

\item{var_method}{variance method.}

\item{rep_type}{replication type for weights in the bootstrap method for variance estimation passed to \code{\link[survey:as.svrepdesign]{survey::as.svrepdesign()}}.
Default is \code{subbootstrap}.}

\item{bias_inf}{inference method in the bias minimization.
\itemize{
\item if \code{union} then final model is fitting on union of selected variables for selection and outcome models
\item if \code{div} then final model is fitting separately on division of selected variables into relevant ones for
selection and outcome model.
}}

\item{num_boot}{number of iteration for bootstrap algorithms.}

\item{bias_correction}{if \code{TRUE}, then bias minimization estimation used during fitting the model.}

\item{alpha}{Significance level, Default is 0.05.}

\item{cores}{Number of cores in parallel computing.}

\item{keep_boot}{Logical indicating whether statistics from bootstrap should be kept.
By default set to \code{TRUE}}

\item{pmm_exact_se}{Logical value indicating whether to compute the exact
standard error estimate for \code{pmm} estimator. The variance estimator for
estimation based on \code{pmm} can be decomposed into three parts, with the
third being computed using covariance between imputed values for units in
probability sample using predictive matches from non-probability sample.
In most situations this term is negligible and is very computationally
expensive so by default this is set to \code{FALSE}, but it is recommended to
set this value to \code{TRUE} before submitting final results.}

\item{pi_ij}{TODO, either matrix or \code{ppsmat} class object.}
}
\value{
List with selected parameters.
}
\description{
\code{controlInf} constructs a list with all necessary control parameters
for statistical inference.
}
\seealso{
\code{\link[=nonprob]{nonprob()}} -- for fitting procedure with non-probability samples.
}
