% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param.R
\name{par2nMm}
\alias{par2nMm}
\title{Transform Parameter Vector to Multivariate Normal Mixture}
\description{
  Transforms the (numeric) parameter vector of our MLE parametrization of a multivariate
  normal mixture model into the corresponding \code{\link{list}} of
  components determining the model.  Additionally (partly redundantly), the
  dimension \code{p} and number of components \code{k} need to be specified
  as well.
}
\usage{
par2nMm(par, p, k, model = c("EII","VII","EEI","VEI","EVI",
                             "VVI","EEE","VEE","EVV","VVV")
      , name = sprintf("model = \%s , components = \%s", model, k)
       )
}
\arguments{
  \item{par}{the model parameter numeric vector.}
  \item{p}{dimension of data space, i.e., number of variables (aka \dQuote{features}).}
  \item{k}{the number of mixture components, a positive integer.}
  \item{model}{a \code{\link{character}} string, one of those listed; see
    \code{\link{nMm2par}()}'s documentation.}
  \item{name}{a \code{\link{character}} string naming the
    \code{\link{norMmix}} return value.}
}
\value{
    returns a \code{\link{list}} with components
    \item{weight}{..}
    \item{mu}{..}
    \item{Sigma}{..}
    \item{k}{..}
    \item{dim}{..}
}
\seealso{
  This is the inverse function of \code{\link{nMm2par}()}.
}
\examples{
## TODO: Show to get the list, and then how to get a  norMmix() object from the list
str(MW213)
# List of 6
#  $ model : chr "VVV"
#  $ mu    : num [1:2, 1:2] 0 0 30 30
#  $ Sigma : num [1:2, 1:2, 1:2] 1 3 3 11 3 6 6 13
#  $ weight: num [1:2] 0.5 0.5
#  $ k     : int 2
#  $ dim   : int 2
#  - attr(*, "name")= chr "#13 test VVV"
#  - attr(*, "class")= chr "norMmix"

para <- nMm2par(MW213, model="EEE")
par2nMm(para, 2, 2, model="EEE")
}
%% \keyword{}
