% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bip.R
\name{NOSM_bip}
\alias{NOSM_bip}
\title{Compute NOS using a bipartite network}
\usage{
NOSM_bip(net, perc = 1, sl = 1)
}
\arguments{
\item{net}{A network, in the form of an edge list. This should be a matrix or
dataframe with two columns. Each value in a column is a node (e.g. a food
item in a trophic-web). Nodes can be identified using numbers or
characters. For each row (i.e. node pair), the value in the first column is
'consumed' (or pollinated, parasitized etc) by the value in the second
column.}

\item{perc}{(default to 1) - the fraction of node pair comparisons to be
performed to compute NOS. We recommend performing all possible pair
comparisons (perc = 1). However, for exploratory analyses on large sets of
networks (or for very large networks), the possibility of using a lower
fraction of pair comparisons is a useful option.}

\item{sl}{(default is 1) Specifies whether cannibalistic interactions should
be considered as possible and therefore taken into account and removed
during computation ('1') or not ('0').}
}
\value{
A list (two elements) of class 'NOSM' with a 'Type' attribute 'bip'.
  The first element in the list is a vector of overlap values for the "in
  nodes" and the second element is a vector of overlap values for the "out
  nodes".

  The \code{\link{summary.NOSM}} methods provides more useful summary
  statistics.
}
\description{
Computation of NOS using a bipartite network (e.g.
  plant-pollinator network), where nodes can be formally categorized into two
  distinct categories (e.g. plant-pollinators). All nodes in one category
  will be considered as potential partners for the nodes in the other
  category (and vice-versa).
}
\examples{
data(boreal)
y <-  boreal[sample(rownames(boreal), 100, FALSE),] #subset 100 rows for speed
x <- NOSM_bip(y, perc = 1, sl = 1)
summary(x)
}
