% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nowcast.plot.R
\name{nowcast.plot}
\alias{nowcast.plot}
\title{Plot for nowcast output function}
\usage{
nowcast.plot(out, type = "fcst")
}
\arguments{
\item{out}{output of nowcast function.}

\item{type}{'fcst', 'factors', 'eigenvalues','eigenvectors' or 'month_y'. This last one is only available for EM method. 'eigenvalues' and 'eigenvectors' only available to two stages methods.}
}
\description{
Make plots to visualize the output of nowcast function
}
\examples{
\dontrun{
gdp <- month2qtr(x = USGDP$base[,"RGDPGR"])
gdp_position <- which(colnames(USGDP$base) == "RGDPGR")
base <- Bpanel(base = USGDP$base[,-gdp_position],
               trans = USGDP$legend$Transformation[-gdp_position],
               aggregate = TRUE)
now2sq <- nowcast(y = gdp, x = base, r = 2, p = 2, q = 2, method = '2sq')

nowcast.plot(now2sq, type = "fcst")
nowcast.plot(now2sq, type = "factors")
nowcast.plot(now2sq, type = "eigenvalues")
nowcast.plot(now2sq, type = "eigenvectors")

base <- Bpanel(base = USGDP$base[,-gdp_position],
               trans = USGDP$legend$Transformation[-gdp_position],
               aggregate = FALSE)
now2sm <- nowcast(y = gdp, x = base, r = 2, p = 2, q = 2, method = '2sm')

nowcast.plot(now2sm, type = "fcst")
nowcast.plot(now2sm, type = "factors")
nowcast.plot(now2sm, type = "eigenvalues")
nowcast.plot(now2sm, type = "eigenvectors")
}
}
