% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{generate_data}
\alias{generate_data}
\title{Generate the data.}
\usage{
generate_data(n = 1000, model.no = 1)
}
\arguments{
\item{n}{the generated sample size. Default = 1000.}

\item{model.no}{the model number in Tian, Y., & Feng, Y. (2021). Can be 1 or 2. Default = 1.}
}
\value{
A list with two components x and y. x is the predictor matrix and y is the label vector.
}
\description{
Generate the data from two simulation cases in Tian, Y., & Feng, Y. (2021).
}
\examples{
set.seed(123, kind = "L'Ecuyer-CMRG")
train.set <- generate_data(n = 1000, model.no = 1)
x <- train.set$x
y <- train.set$y

}
\references{
Tian, Y., & Feng, Y. (2021). Neyman-Pearson Multi-class Classification via Cost-sensitive Learning. Submitted. Available soon on arXiv.
}
\seealso{
\code{\link{npcs}}, \code{\link{predict.npcs}}, \code{\link{error_rate}}, and \code{\link{gamma_smote}}.
}
