% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_wkbk.R
\name{create_wkbk}
\alias{create_wkbk}
\title{Creates an Excel workbook with worksheets.}
\usage{
create_wkbk(file, df_list, sheetnames, replace = FALSE)
}
\arguments{
\item{file}{filename of workbook to be created}

\item{df_list}{list of data frames to be added as worksheets to workbook}

\item{sheetnames}{character vector of worksheet names}

\item{replace}{Specifies if the file should be replaced if it
already exist (default is FALSE).}
}
\value{
TRUE if the Excel file was successfully created. FALSE if any errors
occurred.
}
\description{
Creates an Excel workbook with worksheets.
}
\examples{
\donttest{
library(nprcgenekeepr)

make_df_list <- function(size) {
  df_list <- list(size)
  if (size <= 0)
    return(df_list)
  for (i in seq_len(size)) {
    n <- sample(2:10, 2, replace = TRUE)
    df <- data.frame(matrix(data = rnorm(n[1] * n[2]), ncol = n[1]))
    df_list[[i]] <- df
  }
  names(df_list) <- paste0("A", seq_len(size))
  df_list
}
df_list <- make_df_list(3)
sheetnames <- names(df_list)
create_wkbk(file = file.path(tempdir(), "example_excel_wkbk.xlsx"),
            df_list = df_list,
            sheetnames = sheetnames, replace = FALSE)
}

}
