% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fillGroupMembers.R
\name{fillGroupMembers}
\alias{fillGroupMembers}
\title{Forms and fills list of animals groups based on provided constraints}
\usage{
fillGroupMembers(
  candidates,
  currentGroups,
  kin,
  ped,
  harem,
  minAge,
  numGp,
  sexRatio
)
}
\arguments{
\item{candidates}{character vector of IDs of the animals available for
use in the group.}

\item{currentGroups}{list of character vectors of IDs of animals currently
assigned
to the group. Defaults to character(0) assuming no groups are existent.}

\item{kin}{list of animals and those animals who are related above a
threshold value.}

\item{ped}{dataframe that is the `Pedigree`. It contains pedigree
information including the IDs listed in \code{candidates}.}

\item{harem}{logical variable when set to \code{TRUE}, the formed groups
have a single male at least \code{minAge} old.}

\item{minAge}{integer value indicating the minimum age to consider in group
formation. Pairwise kinships involving an animal of this age or younger will
 be ignored. Default is 1 year.}

\item{numGp}{integer value indicating the number of groups that should be
formed from the list of IDs. Default is 1.}

\item{sexRatio}{numeric value indicating the ratio of females to males x
(from 0.5 to 20 by increments of 0.5 within the accompanying Shiny
application. A sex ratio of 0 ignores sex in making up groups.}
}
\value{
A list of animal groups and their member animals
}
\description{
Forms and fills list of animals groups based on provided constraints
}
