% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDemographics.R
\name{getDemographics}
\alias{getDemographics}
\title{Get demographic data}
\usage{
getDemographics(colSelect = NULL)
}
\arguments{
\item{colSelect}{(optional) a vector of comma separated strings specifying
which columns of a dataset or view to import}
}
\value{
A data.frame containing LabKey demographic data with the columns
specified in the single parameter provided.
}
\description{
This is a thin wrapper around \code{labkey.selectRows()}.
}
\examples{
\donttest{
library(nprcgenekeepr)
siteInfo <- getSiteInfo()
colSet <- siteInfo$lkPedColumns
source <- " generated by getDemographics: "
pedSourceDf <- tryCatch(getDemographics(colSelect = colSet),
                        warning = function(wCond) {
                          cat(paste0("Warning", source, wCond),
                                     name = "nprcgenekeepr")
                          return(NULL)},
                        error = function(eCond) {
                          cat(paste0("Error", source, eCond),
                                     name = "nprcgenekeepr")
                          return(NULL)}
)
}

}
