% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulate_arm}
\alias{simulate_arm}
\title{Simulate complete data for a single arm}
\usage{
simulate_arm(arm, label = 1)
}
\arguments{
\item{arm}{object of class 'arm'.}

\item{label}{numeric label for the simulated arm, e.g. 0 for control,
1 for treatment}
}
\value{
\item{arm}{label}
  \item{time.accr}{time to accrual}
  \item{time.obs}{time to observation from accrual}
  \item{time.total}{time to observation from start of study}
  \item{censor}{0=censor, 1=event}
  \item{reason}{event description ('[experience ]event', '[loss to ]followup', 'administration[ censoring]')}
  \item{time.surv}{time to event}
  \item{time.loss}{time to loss of follow-up}
}
\description{
Simulate the complete data for a single arm, including time to accrual,
event, and loss of follow-up. No cutoff (by number of events or time) is
applied. Hence, no patients are administratively censored.
}
\examples{
arm0 <- create_arm(size=120, accr_time=6, surv_scale=0.05, loss_scale=0.005, follow_time=12)
simulate_arm(arm0, label=0)
}
\seealso{
\code{\link{create_arm}} for creating an object of class 'arm'.
}
