% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{format.dots}
\alias{format.dots}
\alias{format.quotation}
\alias{format.oneline}
\alias{print.dots}
\alias{print.quotation}
\title{Formatting methods for dots and quotations.}
\usage{
\method{format}{dots}(
  x,
  compact = FALSE,
  show.environments = !compact,
  show.expressions = !compact,
  width = 36,
  ...
)

\method{format}{quotation}(
  x,
  compact = FALSE,
  show.environments = !compact,
  show.expressions = !compact,
  width = 36,
  ...
)

\method{format}{oneline}(x, max.width = 50, width = max.width, ...)

\method{print}{dots}(x, ...)

\method{print}{quotation}(x, ...)
}
\arguments{
\item{x}{An object.}

\item{compact}{Implies \code{show.environments=FALSE} and
\code{show.expressions=FALSE}.}

\item{show.environments}{Whether to show environments for unforced
quotations.}

\item{show.expressions}{Whether to show expressions for forced
quotations.}

\item{width}{See \link[base:format]{base::format}.}

\item{...}{Further parameters passed along to \link[base:format]{base::format}.}

\item{max.width}{See \link[base:format]{base::format}.}
}
\description{
\code{format.dots} constructs a string representation of a dots
object.

\code{format.quotation} constructs a string representation of a
quotation object.

\code{format.oneline} formats a vector or list so that each item is
displayed on one line. It is similar to \link{format.AsIs} but tries
harder with language objects. The "oneline" class is used by
\link{as.data.frame.dots}.
}
