% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing.R
\name{missing_value}
\alias{missing_value}
\alias{missing_}
\alias{missing_.default}
\alias{missing_.dots}
\alias{missing_.quotation}
\alias{list_missing}
\title{R's missing value.}
\usage{
missing_value(n)

missing_(x, unwrap = TRUE)

\method{missing_}{default}(x, unwrap = TRUE)

\method{missing_}{dots}(x, unwrap = TRUE)

\method{missing_}{quotation}(x, unwrap = TRUE)

list_missing(...)
}
\arguments{
\item{n}{Optional; a number. If provided, will return a list of
missing values with this many elements.}

\item{x}{a value, \link{dots}, or list.}

\item{unwrap}{Whether to descend recursively through unevaluated
promises using \code{unwrap(x, TRUE)}}

\item{...}{Arguments evaluated normally. except those which are missing.}
}
\value{
\code{missing_value} returns the symbol with empty name, or a
list of such.

\code{missing_} returns a logical vector.

\code{list_missing} returns a list.
}
\description{
\code{missing_value()} returns R's missing object; what R uses to
represent a missing argument. It is distinct from either \link{NULL} or
\link{NA}.
}
\details{
The missing value occurs naturally in a quoted R expression that has an empty argument:
\preformatted{  exp <- quote( x[1, ] )
  identical(exp[[4]], missing_value()) #TRUE
  is_missing(exp[[4]]) #also TRUE
}
So we can use \code{missing_value()} to help construct expressions:
\preformatted{  substitute(f[x, y], list(x = 1, y=missing_value()))
}
When such an expression is evaluated and starts a function call,
the missing value winds up in the promise expression.
\preformatted{  f <- function(x) arg_expr(x)
  identical(f(), missing_value()) # TRUE
}
During "normal evaluation", finding a missing value in a
variable raises an error.
\preformatted{  m <- missing_value()
  list(m) # raises error
}
This means that it's sometimes tricky to work with missings:
\preformatted{  exp <- quote( x[1, ] )
  cols <- x[[4]]
  x <- list(missing_value(), 2, 3)     # this is ok, but...
  a <- missing_value(); b <- 2; c <- 3 # this stores missing in "cols",
  x <- list(a, b, c)                   # throws an error: "a" missing
}
Generally, keep your missing values wrapped up in lists or quotations,
instead of assigning them to variables directly.
}
\examples{
# These expressions are equivalent:
function(x, y=1) {x+y}
function_(list(x=missing_value, y=1),
          quote( {x+y} ))

# These expressions are also equivalent:
quote(df[,1])
substitute(df[row,col],
           list(row = missing_value(), col = 1))
# How to do the trick of `[` where it can tell which arguments are
# missing:
`[.myclass` <- function(x, ...) {
   indices <- list_missing(...)
   kept.axes <- which(missing_(indices))
   cat(paste0("Keeping axes ", kept_axes, "\n"))
   #...
}
ar <- structure(array(1:24, c(2, 3, 4)))
ar[, 3, ]
}
\seealso{
missing is_missing

missing is_missing
}
