% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsKumaraswamy.R
\name{Neutrosophic Kumaraswamy}
\alias{Neutrosophic Kumaraswamy}
\alias{dnsKumaraswamy}
\alias{pnsKumaraswamy}
\alias{qnsKumaraswamy}
\alias{rnsKumaraswamy}
\title{Neutrosophic Kumaraswamy Distribution}
\usage{
dnsKumaraswamy(x, shape1, shape2)

pnsKumaraswamy(q, shape1, shape2, lower.tail = TRUE)

qnsKumaraswamy(p, shape1, shape2)

rnsKumaraswamy(n, shape1, shape2)
}
\arguments{
\item{x}{a vector or matrix of observations for which the pdf needs to be computed.}

\item{shape1}{the shape parameter, which must be a positive interval.}

\item{shape2}{the shape parameter, which must be a positive interval.}

\item{q}{a vector or matrix of quantiles for which the cdf needs to be computed.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \leq x)}; otherwise, \eqn{P(X >x)}.}

\item{p}{a vector or matrix of probabilities for which the quantile needs to be computed.}

\item{n}{number of random values to be genelambdad.}
}
\value{
\code{pnsKumaraswamy} gives the distribution function

\code{dnsKumaraswamy} gives the density

\code{qnsKumaraswamy} gives the quantile function

\code{rnsKumaraswamy} generates random values from the neutrosophic Kumaraswamy distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the neutrosophic Kumaraswamy distribution with
shape parameters \eqn{\alpha_N} and \eqn{\beta_N}.
}
\details{
The neutrosophic Kumaraswamy distribution with parameters \eqn{\alpha_N} and \eqn{\beta_N}
has density
\deqn{f_N(x) = \alpha_N \beta_N x^{\alpha_N-1}(1-x^{\alpha_N})^{\beta_N - 1}}
for \eqn{0 \le x \le 1}, \eqn{\alpha_N \in (\alpha_L, \alpha_U)} and
 \eqn{\beta_N \in (\beta_L, \beta_U)} are shape parameters.
}
\examples{
dnsKumaraswamy(x = c(0.5, 0.1), shape1 = c(0.23, 0.24), shape2 = c(1, 2))
dnsKumaraswamy(0.5, shape1 = c(0.23, 0.24), shape2 = c(1, 2))


# The cumulative distribution function for the nuetrosophic observation (4,4.1)
pnsKumaraswamy(q = c(.8, .1), shape1 = c(0.23, 0.24), shape2 = c(1, 2))
# The first percentile
qnsKumaraswamy(p = 0.1, shape1 = 0.24, shape2 = 2)

# The quantiles
qnsKumaraswamy(p = c(0.25, 0.5, 0.75), shape1 = c(0.23, 0.24), shape2 = c(1, 2))

# Simulate 10 numbers
rnsKumaraswamy(n = 10, shape1 = c(0.23, 0.24), shape2 = c(1, 2))
}
\references{
Ahsan-ul-Haq, M. (2022). Neutrosophic Kumaraswamy Distribution with Engineering
Application, \emph{Neutrosophic Sets and Systems}, 49, 269-276.
}
