% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dig_correlations.R
\name{dig_correlations}
\alias{dig_correlations}
\title{Search for conditional correlations}
\usage{
dig_correlations(
  x,
  condition = where(is.logical),
  xvars = where(is.numeric),
  yvars = where(is.numeric),
  method = "pearson",
  alternative = "two.sided",
  exact = NULL,
  min_length = 0L,
  max_length = Inf,
  min_support = 0.02,
  ...
)
}
\arguments{
\item{x}{a matrix or data frame with data to search in. The matrix must be
numeric (double) or logical. If \code{x} is a data frame then each column
must be either numeric (double) or logical.}

\item{condition}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use as condition predicates}

\item{xvars}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use for computation of correlations}

\item{yvars}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use for computation of correlations}

\item{method}{a character string indicating which correlation coefficient is
to be used for the test. One of \code{"pearson"}, \code{"kendall"}, or \code{"spearman"}}

\item{alternative}{indicates the alternative hypothesis and must be one of
\code{"two.sided"}, \code{"greater"} or \code{"less"}. \code{"greater"} corresponds to
positive association, \code{"less"} to negative association.}

\item{exact}{a logical indicating whether an exact p-value should be computed.
Used for Kendall's \emph{tau} and Spearman's \emph{rho}. See \code{\link[stats:cor.test]{stats::cor.test()}} for
more information.}

\item{min_length}{the minimum size (the minimum number of predicates) of the
condition to be generated (must be greater or equal to 0). If 0, the empty
condition is generated in the first place.}

\item{max_length}{The maximum size (the maximum number of predicates) of the
condition to be generated. If equal to Inf, the maximum length of conditions
is limited only by the number of available predicates.}

\item{min_support}{the minimum support of a condition to trigger the callback
function for it. The support of the condition is the relative frequency
of the condition in the dataset \code{x}. For logical data, it equals to the
relative frequency of rows such that all condition predicates are TRUE on it.
For numerical (double) input, the support is computed as the mean (over all
rows) of multiplications of predicate values.}

\item{...}{Further arguments, currently unused.}
}
\value{
A tibble with found rules.
}
\description{
Compute correlation between all combinations of \code{xvars} and \code{yvars} columns
of \code{x} in subdata corresponding to conditions generated from \code{condition}
columns.
}
\seealso{
\code{\link[=dig]{dig()}}, \code{\link[stats:cor.test]{stats::cor.test()}}
}
\author{
Michal Burda
}
