% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{run_numbat}
\alias{run_numbat}
\title{Run workflow to decompose tumor subclones}
\usage{
run_numbat(
  count_mat,
  lambdas_ref,
  df_allele,
  genome = "hg38",
  out_dir = tempdir(),
  max_iter = 2,
  max_nni = 100,
  t = 1e-05,
  gamma = 20,
  min_LLR = 5,
  alpha = 1e-04,
  eps = 1e-05,
  max_entropy = 0.5,
  init_k = 3,
  min_cells = 50,
  tau = 0.3,
  max_cost = ncol(count_mat) * tau,
  min_depth = 0,
  common_diploid = TRUE,
  min_overlap = 0.45,
  ncores = 1,
  ncores_nni = ncores,
  random_init = FALSE,
  segs_loh = NULL,
  verbose = TRUE,
  diploid_chroms = NULL,
  use_loh = NULL,
  min_genes = 10,
  skip_nj = FALSE,
  multi_allelic = TRUE,
  p_multi = 1 - alpha,
  plot = TRUE,
  check_convergence = FALSE,
  exclude_neu = TRUE
)
}
\arguments{
\item{count_mat}{dgCMatrix Raw count matrices where rownames are genes and column names are cells}

\item{lambdas_ref}{matrix Either a named vector with gene names as names and normalized expression as values, or a matrix where rownames are genes and columns are pseudobulk names}

\item{df_allele}{dataframe Allele counts per cell, produced by preprocess_allele}

\item{genome}{character Genome version (hg38 or hg19)}

\item{out_dir}{string Output directory}

\item{max_iter}{integer Maximum number of iterations to run the phyologeny optimization}

\item{max_nni}{integer Maximum number of iterations to run NNI in the ML phylogeny inference}

\item{t}{numeric Transition probability}

\item{gamma}{numeric Dispersion parameter for the Beta-Binomial allele model}

\item{min_LLR}{numeric Minimum LLR to filter CNVs}

\item{alpha}{numeric P value cutoff for diploid finding}

\item{eps}{numeric Convergence threshold for ML tree search}

\item{max_entropy}{numeric Entropy threshold to filter CNVs}

\item{init_k}{integer Number of clusters in the initial clustering}

\item{min_cells}{integer Minimum number of cells to run HMM on}

\item{tau}{numeric Factor to determine max_cost as a function of the number of cells (0-1)}

\item{max_cost}{numeric Likelihood threshold to collapse internal branches}

\item{min_depth}{integer Minimum allele depth}

\item{common_diploid}{logical Whether to find common diploid regions in a group of peusdobulks}

\item{min_overlap}{numeric Minimum CNV overlap threshold}

\item{ncores}{integer Number of threads to use}

\item{ncores_nni}{integer Number of threads to use for NNI}

\item{random_init}{logical Whether to initiate phylogney using a random tree (internal use only)}

\item{segs_loh}{dataframe Segments of clonal LOH to be excluded}

\item{verbose}{logical Verbosity}

\item{diploid_chroms}{vector Known diploid chromosomes}

\item{use_loh}{logical Whether to include LOH regions in the expression baseline}

\item{min_genes}{integer Minimum number of genes to call a segment}

\item{skip_nj}{logical Whether to skip NJ tree construction and only use UPGMA}

\item{multi_allelic}{logical Whether to call multi-allelic CNVs}

\item{p_multi}{numeric P value cutoff for calling multi-allelic CNVs}

\item{plot}{logical Whether to plot results}

\item{check_convergence}{logical Whether to terminate iterations based on consensus CNV convergence}

\item{exclude_neu}{logical Whether to exclude neutral segments from CNV retesting (internal use only)}
}
\value{
a status code
}
\description{
Run workflow to decompose tumor subclones
}
