% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{plot_exp_roll}
\alias{plot_exp_roll}
\title{Plot single-cell smoothed expression magnitude heatmap}
\usage{
plot_exp_roll(
  gexp_roll_wide,
  hc,
  k,
  gtf,
  lim = 0.8,
  n_sample = 300,
  reverse = TRUE,
  plot_tree = TRUE
)
}
\arguments{
\item{gexp_roll_wide}{matrix Cell x gene smoothed expression magnitudes}

\item{hc}{hclust Hierarchical clustring result}

\item{k}{integer Number of clusters}

\item{gtf}{dataframe Transcript GTF}

\item{lim}{numeric Limit for expression magnitudes}

\item{n_sample}{integer Number of cells to subsample}

\item{reverse}{logical Whether to reverse the cell order}

\item{plot_tree}{logical Whether to plot the dendrogram}
}
\value{
ggplot A single-cell heatmap of window-smoothed expression CNV signals
}
\description{
Plot single-cell smoothed expression magnitude heatmap
}
\examples{
p = plot_exp_roll(gexp_roll_example, gtf = gtf_hg38, hc = hc_example, k = 3)
}
