% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_domestic_violence_annual_report.R
\name{nyc_domestic_violence_annual_report}
\alias{nyc_domestic_violence_annual_report}
\title{Annual Report on Domestic Violence Initiatives, Indicators and Factors}
\source{
NYC Open Data: <https://data.cityofnewyork.us/Social-Services/Annual-Report-on-Domestic-Violence-Initiatives-Ind/7t9i-jsfp/about_data>
}
\usage{
nyc_domestic_violence_annual_report(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing Annual Report on Domestic Violence Initiatives, Indicators and Factors data.
}
\description{
Downloads Annual Report on Domestic Violence Initiatives, Indicators and Factors data from NYC Open Data.
}
\details{
The information in the report is required under Local Law 38 of 2019.
}
\examples{
# Quick example (fetch 10 rows)
small_sample <- nyc_domestic_violence_annual_report(limit = 10)
head(small_sample)

\donttest{
nyc_domestic_violence_annual_report(limit = 5000)
nyc_domestic_violence_annual_report(filters = list(category = "FJC_Client_Visits"))
}
}
