% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countAnnotations.R
\name{countAnnotations}
\alias{countAnnotations}
\title{Gets the number of annotations on the given layer of the given graph.}
\usage{
countAnnotations(labbcat.url, id, layerId)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{A graph ID (i.e. transcript name)}

\item{layerId}{A layer name}
}
\value{
The number of annotations on that layer
}
\description{
Returns the number of annotations on the given layer of the given
graph (transcript).
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Count the number of words in UC427_ViktoriaPapp_A_ENG.eaf
token.count <- countAnnotations(labbcat.url, "UC427_ViktoriaPapp_A_ENG.eaf", "orthography")
}

}
\seealso{
\code{\link{getGraphIds}}
\code{\link{getGraphIdsInCorpus}}
\code{\link{getGraphIdsWithParticipant}}
}
\keyword{graph}
\keyword{transcript}
