% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_moves.R
\name{custom_moves}
\alias{custom_moves}
\title{Customise samplers for outbreaker}
\usage{
custom_moves(...)
}
\arguments{
\item{...}{A list or a series of named, comma-separated functions
implementing movements of parameters or augmented data.}
}
\value{
A named list of movement functions with a single argument 'param', with
    class \code{outbreaker_moves}.
}
\description{
This function is used to specify customised movement functions
(a.k.a. samplers) for outbreaker. Custom functions are specified as a named
list or series of comma-separated, named arguments, indicating which type of
movement they implement. Values currently available are:
}
\details{
\itemize{

\item \code{pi}: movement of the reporting probability; by default, the function
\code{cpp_move_pi} is used.

\item \code{a}: movement of the first spatial parameter; by default, the function
\code{cpp_move_a} is used.

\item \code{b}: movement of the second  spatial parameter; by default, the function
\code{cpp_move_b} is used.

\item \code{alpha}: movement of the transmission tree, by randomly proposing
infectors in the pool of cases infected before; by default, the function
\code{cpp_move_alpha} is used.

\item \code{swap_cases}: movement of the transmission tree, by swapping
infectors and infected cases; by default, the function
\code{cpp_move_swap_cases} is used.

\item \code{ancestors}: movement of the transmission tree, by changing
the ancestors of the different trees in a cluster; by default, the function
\code{cpp_move_ancestors} is used.

\item \code{t_inf}: movement of the date of infection; by default, the
function \code{cpp_move_t_inf} is used.

\item \code{kappa}: movement of the number generations between cases; by
default, the function \code{cpp_move_kappa} is used.

}


Movement functions must have an argument \code{param}, which is a list of
parameters and augmented data of the class \code{\link{create_param}}.
Each movement function will be enclosed with its other arguments, so that the
resulting function will have a single argument 'param'. For non-standard
movements (i.e. none of the names specified above), the closure will contain:

\itemize{

\item \code{data}: a list of named items containing input data as returned by
\code{\link{outbreaker_data}}

\item \code{config}:  a list of named items containing input data as returned by
\code{\link{create_config}}

\item \code{likelihoods}: a list of named custom likelihood functions as returned by
\code{\link{custom_likelihoods}}

\item \code{priors}: a list of named custom prior functions as returned by
\code{\link{custom_priors}}

}
}
\author{
Initial version by Thibaut Jombart, rewritten by Alexis Robert (\email{alexis.robert@lshtm.ac.uk})
}
