% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oXim-main.R
\name{readEchograms}
\alias{readEchograms}
\title{Takes outputs from Echopen and generates a matrix to calculate Oxycline.}
\usage{
readEchograms(fileMode = NULL, directoryMode = NULL, validFish38 = c(-100,
  -21), validBlue38 = c(-100, -56), upLimitFluid120 = -53,
  pinInterval = 50, date.format = "\%d-\%m-\%Y \%H:\%M:\%S", ...)
}
\arguments{
\item{fileMode}{List with needed variables to read single Matlab files. See details below.}

\item{directoryMode}{List with needed variables to read Matlab files from directory. See details below.}

\item{validFish38}{Range of valid values for Fish-38kHz.}

\item{validBlue38}{Range of valid values for Blue-38kHz.}

\item{upLimitFluid120}{Upper limit for Fluidlike-120kHz.}

\item{pinInterval}{Time threshold (in secs) to consider separate two matrices (echograms).}

\item{date.format}{A character string. The default method is \code{\%Y-\%m-\%d \%H:\%M:\%S}.}

\item{...}{Extra arguments (not used for now).}
}
\description{
This function search outputs of Echoopen for Fluid-like, Blue noise
and Fish and use them to make a filtered matrix to calculate the Oxycline limits.
}
\details{
\code{fileMode} must be a \code{list} with the next structure: \code{fish38_file} (directory for fish38 file),
\code{blue38_file} (directory for blue38 file) and \code{fluid120_file} (directory for fluid120 file).

Similarly, \code{directoryMode} must be a \code{list} with the next structure: \code{directory} (folder
where the files are storaged), \code{fish38_pattern} (text pattern for recognizing fish38 files),
\code{blue38_pattern} (text pattern for recognizing blue38 files) and \code{fluid120_pattern}
(text pattern for recognizing fluid120 files).
}
\examples{
fileMode <- list(fish38_file   = system.file("extdata", "fish38.mat", package = "oXim"),
                 fluid120_file = system.file("extdata", "fluid120.mat", package = "oXim"),
                 blue38_file   = system.file("extdata", "blue38.mat", package = "oXim"))
echoData <- readEchograms(fileMode = fileMode)
print(echoData)

}
