% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.R
\name{df_col_obj_implode}
\alias{df_col_obj_implode}
\title{Change to string nested lists in a given data.frame}
\usage{
df_col_obj_implode(
  df,
  col,
  obj_prop = NULL,
  nested = TRUE,
  cell_header = "",
  objs_glue = "----\\n",
  cell_footer = "",
  obj_header = "",
  props_glue = "\\n",
  obj_footer = "",
  prop_fmt = "\%s: \%s",
  null_prop_str = "[null]",
  on_missing_col = "warn"
)
}
\arguments{
\item{df}{data.frame, input data.frame}

\item{col}{character vector, df column names containing objects}

\item{obj_prop}{NULL/character vector, object properties (NULL means all)}

\item{nested}{flag, whether the rows of the columns contain multiple objects}

\item{cell_header}{string/NULL, cell header}

\item{objs_glue}{string, how to combine objects}

\item{cell_footer}{string/NULL, cell footer}

\item{obj_header}{string/NULL, object header}

\item{props_glue}{string, how to combine properties}

\item{obj_footer}{string/NULL, object footer}

\item{prop_fmt}{string, sprintf fmt parameter with two `\%s` fields (property}

\item{null_prop_str}{string, value for NULL object property
name, value)}

\item{on_missing_col}{string, behavior for missing column(s):
"warn" - log warning, "skip" - skip missing column(s), "stop" - throw error}
}
\value{
Modified input data.frame
}
\description{
Change to string nested lists in a given data.frame
}
\examples{
df <- as.data.frame(do.call(cbind, list(
  a = list(list(x = 1, y = 2), list(x = 3, y = 4)),
  b = list("z", "z")
)))
df_col_obj_implode(df, "a", c("x", "y"), nested = FALSE, props_glue = ", ")

}
