% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_embeddings.R
\name{embeddings_create_request}
\alias{embeddings_create_request}
\title{API embeddings: create embeddings}
\usage{
embeddings_create_request(
  api_key,
  input,
  model,
  encoding_format = NULL,
  user = NULL
)
}
\arguments{
\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}

\item{input}{character vector, input text to embed, encoded as a string
or array of tokens. To embed multiple inputs in a single request, pass
an array of strings or array of token arrays. The input must not exceed
the max input tokens for the model (8192 tokens for text-embedding-ada-002),
cannot be an empty string, and any array must be 2048 dimensions or less.}

\item{model}{string, ID of the model to use. You can use the list models API
(https://platform.openai.com/docs/api-reference/models/list)
to see all of your available models, or see our model overview
(https://platform.openai.com/docs/models/overview)
for descriptions of them.}

\item{encoding_format}{string, he format to return the embeddings in. Can be
either float (default) or base64.}

\item{user}{string, a unique identifier representing your end-user, which can
help OpenAI to monitor and detect abuse. To learn more visit
https://platform.openai.com/docs/guides/safety-best-practices/end-user-ids}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
Creates an embedding vector representing the input text. To get more details, visit
https://platform.openai.com/docs/api-reference/embeddings/create
https://platform.openai.com/docs/guides/embeddings
}
