% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trades.R
\name{tradeImpacts}
\alias{tradeImpacts}
\title{Trade impacts.}
\usage{
tradeImpacts(trades)
}
\arguments{
\item{trades}{\code{\link{trades}} data.}
}
\value{
A data.frame containing a summary of market order impacts:
\describe{
  \item{id}{market order id}
  \item{min.price}{minimum executed price}
  \item{max.price}{maximum executed price}
  \item{vwap}{VWAP obtained by market order}
  \item{hits}{number of limit orders hit by market order}
  \item{vol}{total volume removed by this impact}
  \item{start.time}{(local) start time of this impact}
  \item{end.time}{(local) end time of this impact}
  \item{dir}{direction of this impact (buy or sell)}
}
}
\description{
Generates a data.frame containing order book impacts.
}
\details{
An impact consists of 1 or more limit orders being hit in order to fulfil a
market order.
}
\examples{

# get impacts data.frame from trades data.
impacts <- tradeImpacts(lob.data$trades)

# impacts (in bps) 
sell.bps <- with(impacts[impacts$dir == "sell", ], {
  (max.price-min.price)/max.price
})
10000*summary(sell.bps[sell.bps > 0])

}
\author{
phil
}

