% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocd.R
\name{new_Chan}
\alias{new_Chan}
\title{construtor for subclass 'Chan' in class 'ChangepointDetector'}
\usage{
new_Chan(dim, thresh, p0, w, lambda)
}
\arguments{
\item{dim}{Data dimension, all new data must be of this dimension}

\item{thresh}{Detection threshold. A positive real number.}

\item{p0}{A sparsity parameter between 0 and 1. It is the assumed fraction of
nonzero coordinates of change. Default to \code{1/sqrt(dim)}.}

\item{w}{Window size parameter.
Number of most recent data points to keep track in memory. Default is 200.}

\item{lambda}{A tuning parameter used by the Chan (2017) method.  Default is
\code{sqrt(8)-2}.}
}
\value{
An object of S3 subclass 'Chan' in class 'ChangepointDetector'.
}
\description{
construtor for subclass 'Chan' in class 'ChangepointDetector'
}
\details{
It is preferred to use \code{\link{ChangepointDetector}} for
construction.
}
\examples{
detector <- new_Chan(dim=100, thresh=8.7, p0=0.1, w=200, lambda=sqrt(8)-2)
}
\references{
Chan, H. P. (2017) Optimal sequential detection in multi-stream data.
\emph{Ann. Statist.}, \strong{45}, 2736--2763.
}
