% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{secondsToCtime}
\alias{secondsToCtime}
\title{Time interval as colon-separated string}
\usage{
secondsToCtime(sec)
}
\arguments{
\item{sec}{length of time interval in seconds.}
}
\value{
A string with a colon-separated time interval.
}
\description{
Convert a time interval to a colon-separated string
}
\examples{

library(oce)
cat("   10 s = ", secondsToCtime(10), "\\n", sep="")
cat("   61 s = ", secondsToCtime(61), "\\n", sep="")
cat("86400 s = ", secondsToCtime(86400), "\\n", sep="")
}
\author{
Dan Kelley
}
\seealso{
See \code{\link{ctimeToSeconds}}, the inverse of this.

Other things related to time: \code{\link{ctimeToSeconds}},
  \code{\link{julianCenturyAnomaly}},
  \code{\link{julianDay}}, \code{\link{numberAsHMS}},
  \code{\link{numberAsPOSIXct}},
  \code{\link{oce.as.POSIXlt}},
  \code{\link{unabbreviateYear}}
}

