% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gps.R
\name{as.gps}
\alias{as.gps}
\title{Coerce data into a GPS dataset}
\usage{
as.gps(longitude, latitude, filename = "")
}
\arguments{
\item{longitude}{the longitude in decimal degrees, positive east of
Greenwich, or a data frame with columns named \code{latitude} and
\code{longitude}, in which case these values are extracted from the data
frame and the second argument is ignored.}

\item{latitude}{the latitude in decimal degrees, positive north of the
Equator.}

\item{filename}{name of file containing data (if applicable).}
}
\value{
An object of \code{\link{gps-class}}.
}
\description{
Coerces a sequence of longitudes and latitudes into a GPS dataset.
This may be used when \code{\link{read.gps}} cannot read a file, or when the
data have been manipulated.
}
\seealso{
Other things related to \code{gps} data: \code{\link{[[,gps-method}},
  \code{\link{[[<-,gps-method}}, \code{\link{gps-class}},
  \code{\link{plot,gps-method}}, \code{\link{read.gps}},
  \code{\link{summary,gps-method}}
}
\author{
Dan Kelley
}
