% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section.R
\docType{methods}
\name{subset,section-method}
\alias{subset,section-method}
\title{Subset a Section Object}
\usage{
\S4method{subset}{section}(x, subset, ...)
}
\arguments{
\item{x}{A \code{\link{section-class}} object.}

\item{subset}{A condition to be applied to the \code{data} portion of \code{x}.
See \sQuote{Details}.}

\item{...}{Optional arguments, which may include \code{indices}, a vector
of the indices of stations to be kept (starting at 1 for the first station).}
}
\value{
A new \code{section} object.
}
\description{
This function is somewhat analogous to \code{\link{subset.data.frame}}.  The
condition set by \code{subset} may be in terms of \code{stationId} or any
combination of \code{longitude}, \code{latitude} and \code{time}.  However,
\code{stationId} may not be combined with the others; to get that effect, call
this function more than once.
}
\examples{
library(oce)
data(section)
GS <- subset(section, 109<=stationId&stationId<=129)

}
\seealso{
Other things related to \code{section} data: \code{\link{[[,section-method}},
  \code{\link{[[<-,section-method}},
  \code{\link{as.section}},
  \code{\link{handleFlags,section-method}},
  \code{\link{plot,section-method}},
  \code{\link{read.section}}, \code{\link{section-class}},
  \code{\link{sectionAddStation}},
  \code{\link{sectionGrid}}, \code{\link{sectionSmooth}},
  \code{\link{sectionSort}}, \code{\link{section}},
  \code{\link{summary,section-method}}
}
\author{
Dan Kelley
}
