% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sealevel.R
\docType{methods}
\name{plot,sealevel-method}
\alias{plot,sealevel-method}
\title{Plot Sealevel Data}
\usage{
\S4method{plot}{sealevel}(x, which = 1:3, adorn = NULL,
  drawTimeRange = getOption("oceDrawTimeRange"), mgp = getOption("oceMgp"),
  mar = c(mgp[1] + 0.5, mgp[1] + 1.5, mgp[2] + 1, mgp[2] + 3/4),
  marginsAsImage = FALSE, debug = getOption("oceDebug"), ...)
}
\arguments{
\item{x}{an object of class \code{"sealevel"}, e.g. as read by
\code{\link{read.sealevel}}.}

\item{which}{a numerical or string vector indicating desired plot types,
with possibilities 1 or \code{"all"} for a time-series of all the data, 2 or
\code{"month"} for a time-series of just the first month, 3 or
\code{"spectrum"} for a power spectrum (truncated to frequencies below 0.1
cycles per hour, or 4 or \code{"cumulativespectrum"} for a cumulative
integral of the power spectrum.}

\item{adorn}{(\strong{Defunct})
An \code{\link{expression}} or vector of expressions that contain
R code that is to be executed immediately after each panel of the plot.
If the number of expressions matches the number of panels, then the 
expressions are used for the corresponding panels; otherwise, the
expression list is extended to match the number of panels (i.e.
to obtain \code{length(which)} elements). Note that \code{adorn}
is a dangerous argument, because if the expressions contained
therein set up local storage, there is a chance of entirely
disrupting the plotting. \strong{For this reason, \code{adorn} was
marked as defunct in June 2016, and will be removed entirely 
after the July CRAN release.} Users with existing code that uses
\code{adorn} should simply plot the panels individually, and
use conventional R functions, e.g. \code{\link{lines}} etc.,
after each panel, to achieve the desired effect.  (See
\code{\link{oce-defunct}} for notes on other deprecated or
defunct \code{oce} features.)}

\item{drawTimeRange}{boolean that applies to panels with time as the
horizontal axis, indicating whether to draw the time range in the top-left
margin of the plot.}

\item{mgp}{3-element numerical vector to use for \code{par(mgp)}, and also
for \code{par(mar)}, computed from this.  The default is tighter than the R
default, in order to use more space for the data and less for the axes.}

\item{mar}{value to be used with \code{\link{par}("mar")}.}

\item{marginsAsImage}{boolean, \code{TRUE} to put a wide margin to the right
of time-series plots, matching the space used up by a palette in an
\code{\link{imagep}} plot.}

\item{debug}{a flag that turns on debugging, if it exceeds 0.}

\item{\dots}{optional arguments passed to plotting functions.}
}
\value{
None.
}
\description{
Creates a plot for a sea-level dataset, in one of two varieties.  Depending
on the length of \code{which}, either a single-panel or multi-panel plot is
drawn.  If there is just one panel, then the value of \code{par} used in
\code{plot,sealevel-method} is retained upon exit, making it convenient to add to
the plot.  For multi-panel plots, \code{par} is returned to the value it had
before the call.
}
\examples{
library(oce)
data(sealevel)
## local Halifax time is UTC + 4h; see [2] on timing
juan <- as.POSIXct("2003-09-29 00:15:00", tz="UTC")+4*3600
plot(sealevel, which=1, xlim=juan+86400*c(-7, 7))
abline(v=juan, col='red')

}
\references{
The example refers to Hurricane Juan, which caused a great deal
of damage to Halifax in 2003.  Since this was in the era of the digital
photo, a casual web search will uncover some spectacular images of damage,
from both wind and storm surge. A map of the path of Hurricane Juan across
Nova Scotia is at
\url{http://ec.gc.ca/ouragans-hurricanes/default.asp?lang=En&n=222F51F7-1}.
Landfall, very near the site of this sealevel
gauge, was between 00:10 and 00:20 Halifax local time on Monday, Sept 29,
2003.
}
\seealso{
The documentation for \code{\link{sealevel-class}} explains the
structure of sealevel objects, and also outlines the other functions dealing
with them.

Other functions that plot \code{oce} data: \code{\link{plot,adp-method}},
  \code{\link{plot,adv-method}},
  \code{\link{plot,amsr-method}},
  \code{\link{plot,argo-method}},
  \code{\link{plot,bremen-method}},
  \code{\link{plot,cm-method}},
  \code{\link{plot,coastline-method}},
  \code{\link{plot,ctd-method}},
  \code{\link{plot,gps-method}},
  \code{\link{plot,ladp-method}},
  \code{\link{plot,lisst-method}},
  \code{\link{plot,lobo-method}},
  \code{\link{plot,met-method}},
  \code{\link{plot,odf-method}},
  \code{\link{plot,rsk-method}},
  \code{\link{plot,satellite-method}},
  \code{\link{plot,section-method}},
  \code{\link{plot,tidem-method}},
  \code{\link{plot,topo-method}},
  \code{\link{plot,windrose-method}},
  \code{\link{plotProfile}}, \code{\link{plotScan}},
  \code{\link{plotTS}}, \code{\link{tidem-class}}

Other things related to \code{sealevel} data: \code{\link{[[,sealevel-method}},
  \code{\link{[[<-,sealevel-method}},
  \code{\link{as.sealevel}}, \code{\link{read.sealevel}},
  \code{\link{sealevel-class}},
  \code{\link{sealevelTuktoyaktuk}},
  \code{\link{sealevel}},
  \code{\link{subset,sealevel-method}},
  \code{\link{summary,sealevel-method}}
}
\author{
Dan Kelley
}
