% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisst.R
\name{as.lisst}
\alias{as.lisst}
\title{Coerce Data Into a LISST Object}
\usage{
as.lisst(data, filename = "", year = 0, tz = "UTC", longitude = NA,
  latitude = NA)
}
\arguments{
\item{data}{A table (or matrix) containing 42 columns, as in a LISST data
file.}

\item{filename}{Name of file containing the data.}

\item{year}{Year in which the first observation was made.  This is necessary
because LISST timestamps do not indicate the year of observation.  The
default value is odd enough to remind users to include this argument.}

\item{tz}{Timezone of observations.  This is necessary because LISST
timestamps do not indicate the timezone.}

\item{longitude}{Longitude of observation.}

\item{latitude}{Latitude of observation.}
}
\value{
An object of \code{\link{lisst-class}}.
}
\description{
Coerce data into a lisst object
If \code{data} contains fewer than 42 columns, an error is reported.  If it
contains more than 42 columns, only the first 42 are used.  This is used by
\code{\link{read.lisst}}, the documentation on which explains the meanings
of the columns.
}
\seealso{
Other things related to \code{lisst} data: \code{\link{[[,lisst-method}},
  \code{\link{[[<-,lisst-method}},
  \code{\link{lisst-class}},
  \code{\link{plot,lisst-method}},
  \code{\link{read.lisst}},
  \code{\link{summary,lisst-method}}
}
\author{
Dan Kelley
}
\concept{things related to \code{lisst} data}
