      subroutine md_driver(colat, elong, date, n,
     1 declination, inclination, intensity)

      implicit double precision (a-h,o-z)
      double precision colat(n), elong(n), date(n)
      double precision declination(n), inclination(n), intensity(n)
      double precision x, y, z
      isv = 0
      itype = 1
      alt = 0.0
      do i = 1, n
         call igrf12syn(isv,date(i),itype,alt,colat(i),elong(i),x,y,z,f)
         declination(i) = 57.2957795130823*atan2(y,x)
         inclination(i) = 57.2957795130823*atan2(z,sqrt(x**2+y**2))
         intensity(i) = f
      end do
      return
      end

      subroutine igrf12syn (isv,date,itype,alt,colat,elong,x,y,z,f)
c
c     This is a synthesis routine for the 12th generation IGRF as agreed 
c     in December 2014 by IAGA Working Group V-MOD. It is valid 1900.0 to
c     2020.0 inclusive. Values for dates from 1945.0 to 2010.0 inclusive are 
c     definitive, otherwise they are non-definitive.
c   INPUT
c     isv   = 0 if main-field values are required
c     isv   = 1 if secular variation values are required
c     date  = year A.D. Must be greater than or equal to 1900.0 and 
c             less than or equal to 2025.0. Warning message is given 
c             for dates greater than 2020.0. Must be double precision.
c     itype = 1 if geodetic (spheroid)
c     itype = 2 if geocentric (sphere)
c     alt   = height in km above sea level if itype = 1
c           = distance from centre of Earth in km if itype = 2 (>3485 km)
c     colat = colatitude (0-180)
c     elong = east-longitude (0-360)
c     alt, colat and elong must be double precision.
c   OUTPUT
c     x     = north component (nT) if isv = 0, nT/year if isv = 1
c     y     = east component (nT) if isv = 0, nT/year if isv = 1
c     z     = vertical component (nT) if isv = 0, nT/year if isv = 1
c     f     = total intensity (nT) if isv = 0, rubbish if isv = 1
c
c     To get the other geomagnetic elements (D, I, H and secular
c     variations dD, dH, dI and dF) use routines ptoc and ptocsv.
c
c     Adapted from 8th generation version to include new maximum degree for
c     main-field models for 2000.0 and onwards and use WGS84 spheroid instead
c     of International Astronomical Union 1966 spheroid as recommended by IAGA
c     in July 2003. Reference radius remains as 6371.2 km - it is NOT the mean
c     radius (= 6371.0 km) but 6371.2 km is what is used in determining the
c     coefficients. Adaptation by Susan Macmillan, August 2003 (for 
c     9th generation), December 2004, December 2009 & December 2014.
c
c     Coefficients at 1995.0 incorrectly rounded (rounded up instead of
c     to even) included as these are the coefficients published in Excel 
c     spreadsheet July 2005.
c
      implicit double precision (a-h,o-z)
      dimension gh(3451),g0(120),g1(120),g2(120),g3(120),g4(120),
     1          g5(120),g6(120),g7(120),g8(120),g9(120),ga(120),
     2          gb(120),gc(120),gd(120),ge(120),gf(120),gg(120),
     3          gi(120),gj(120),gk(195),gl(195),gm(195),gp(195),
     4          gq(195),gr(195),
     5          p(105),q(105),cl(13),sl(13)
      equivalence (g0,gh(1)),(g1,gh(121)),(g2,gh(241)),(g3,gh(361)),
     1            (g4,gh(481)),(g5,gh(601)),(g6,gh(721)),(g7,gh(841)),
     2            (g8,gh(961)),(g9,gh(1081)),(ga,gh(1201)),
     3            (gb,gh(1321)),(gc,gh(1441)),(gd,gh(1561)),
     4            (ge,gh(1681)),(gf,gh(1801)),(gg,gh(1921)),
     5            (gi,gh(2041)),(gj,gh(2161)),(gk,gh(2281)),
     6            (gl,gh(2476)),(gm,gh(2671)),(gp,gh(2866)),
     7            (gq,gh(3061)),(gr,gh(3256))
c
c *** oce change: the following data blocks had comments for the year,
c *** but these were removed to avoid pages of warnings in the R
c *** package building process.
      data g0/ -31543.,-2298., 5922., -677., 2905.,-1061.,  924., 1121.,
     1           1022.,-1469., -330., 1256.,    3.,  572.,  523.,  876.,
     2            628.,  195.,  660.,  -69., -361., -210.,  134.,  -75.,
     3           -184.,  328., -210.,  264.,   53.,    5.,  -33.,  -86.,
     4           -124.,  -16.,    3.,   63.,   61.,   -9.,  -11.,   83.,
     5           -217.,    2.,  -58.,  -35.,   59.,   36.,  -90.,  -69.,
     6             70.,  -55.,  -45.,    0.,  -13.,   34.,  -10.,  -41.,
     7             -1.,  -21.,   28.,   18.,  -12.,    6.,  -22.,   11.,
     8              8.,    8.,   -4.,  -14.,   -9.,    7.,    1.,  -13.,
     9              2.,    5.,   -9.,   16.,    5.,   -5.,    8.,  -18.,
     a              8.,   10.,  -20.,    1.,   14.,  -11.,    5.,   12.,
     b             -3.,    1.,   -2.,   -2.,    8.,    2.,   10.,   -1.,
     c             -2.,   -1.,    2.,   -3.,   -4.,    2.,    2.,    1.,
     d             -5.,    2.,   -2.,    6.,    6.,   -4.,    4.,    0.,
     e              0.,   -2.,    2.,    4.,    2.,    0.,    0.,   -6./
      data g1/ -31464.,-2298., 5909., -728., 2928.,-1086., 1041., 1065.,
     1           1037.,-1494., -357., 1239.,   34.,  635.,  480.,  880.,
     2            643.,  203.,  653.,  -77., -380., -201.,  146.,  -65.,
     3           -192.,  328., -193.,  259.,   56.,   -1.,  -32.,  -93.,
     4           -125.,  -26.,   11.,   62.,   60.,   -7.,  -11.,   86.,
     5           -221.,    4.,  -57.,  -32.,   57.,   32.,  -92.,  -67.,
     6             70.,  -54.,  -46.,    0.,  -14.,   33.,  -11.,  -41.,
     7              0.,  -20.,   28.,   18.,  -12.,    6.,  -22.,   11.,
     8              8.,    8.,   -4.,  -15.,   -9.,    7.,    1.,  -13.,
     9              2.,    5.,   -8.,   16.,    5.,   -5.,    8.,  -18.,
     a              8.,   10.,  -20.,    1.,   14.,  -11.,    5.,   12.,
     b             -3.,    1.,   -2.,   -2.,    8.,    2.,   10.,    0.,
     c             -2.,   -1.,    2.,   -3.,   -4.,    2.,    2.,    1.,
     d             -5.,    2.,   -2.,    6.,    6.,   -4.,    4.,    0.,
     e              0.,   -2.,    2.,    4.,    2.,    0.,    0.,   -6./
      data g2/ -31354.,-2297., 5898., -769., 2948.,-1128., 1176., 1000.,
     1           1058.,-1524., -389., 1223.,   62.,  705.,  425.,  884.,
     2            660.,  211.,  644.,  -90., -400., -189.,  160.,  -55.,
     3           -201.,  327., -172.,  253.,   57.,   -9.,  -33., -102.,
     4           -126.,  -38.,   21.,   62.,   58.,   -5.,  -11.,   89.,
     5           -224.,    5.,  -54.,  -29.,   54.,   28.,  -95.,  -65.,
     6             71.,  -54.,  -47.,    1.,  -14.,   32.,  -12.,  -40.,
     7              1.,  -19.,   28.,   18.,  -13.,    6.,  -22.,   11.,
     8              8.,    8.,   -4.,  -15.,   -9.,    6.,    1.,  -13.,
     9              2.,    5.,   -8.,   16.,    5.,   -5.,    8.,  -18.,
     a              8.,   10.,  -20.,    1.,   14.,  -11.,    5.,   12.,
     b             -3.,    1.,   -2.,   -2.,    8.,    2.,   10.,    0.,
     c             -2.,   -1.,    2.,   -3.,   -4.,    2.,    2.,    1.,
     d             -5.,    2.,   -2.,    6.,    6.,   -4.,    4.,    0.,
     e              0.,   -2.,    2.,    4.,    2.,    0.,    0.,   -6./
      data g3/ -31212.,-2306., 5875., -802., 2956.,-1191., 1309.,  917.,
     1           1084.,-1559., -421., 1212.,   84.,  778.,  360.,  887.,
     2            678.,  218.,  631., -109., -416., -173.,  178.,  -51.,
     3           -211.,  327., -148.,  245.,   58.,  -16.,  -34., -111.,
     4           -126.,  -51.,   32.,   61.,   57.,   -2.,  -10.,   93.,
     5           -228.,    8.,  -51.,  -26.,   49.,   23.,  -98.,  -62.,
     6             72.,  -54.,  -48.,    2.,  -14.,   31.,  -12.,  -38.,
     7              2.,  -18.,   28.,   19.,  -15.,    6.,  -22.,   11.,
     8              8.,    8.,   -4.,  -15.,   -9.,    6.,    2.,  -13.,
     9              3.,    5.,   -8.,   16.,    6.,   -5.,    8.,  -18.,
     a              8.,   10.,  -20.,    1.,   14.,  -11.,    5.,   12.,
     b             -3.,    1.,   -2.,   -2.,    8.,    2.,   10.,    0.,
     c             -2.,   -1.,    2.,   -3.,   -4.,    2.,    2.,    1.,
     d             -5.,    2.,   -2.,    6.,    6.,   -4.,    4.,    0.,
     e              0.,   -2.,    1.,    4.,    2.,    0.,    0.,   -6./
      data g4/ -31060.,-2317., 5845., -839., 2959.,-1259., 1407.,  823.,
     1           1111.,-1600., -445., 1205.,  103.,  839.,  293.,  889.,
     2            695.,  220.,  616., -134., -424., -153.,  199.,  -57.,
     3           -221.,  326., -122.,  236.,   58.,  -23.,  -38., -119.,
     4           -125.,  -62.,   43.,   61.,   55.,    0.,  -10.,   96.,
     5           -233.,   11.,  -46.,  -22.,   44.,   18., -101.,  -57.,
     6             73.,  -54.,  -49.,    2.,  -14.,   29.,  -13.,  -37.,
     7              4.,  -16.,   28.,   19.,  -16.,    6.,  -22.,   11.,
     8              7.,    8.,   -3.,  -15.,   -9.,    6.,    2.,  -14.,
     9              4.,    5.,   -7.,   17.,    6.,   -5.,    8.,  -19.,
     a              8.,   10.,  -20.,    1.,   14.,  -11.,    5.,   12.,
     b             -3.,    1.,   -2.,   -2.,    9.,    2.,   10.,    0.,
     c             -2.,   -1.,    2.,   -3.,   -4.,    2.,    2.,    1.,
     d             -5.,    2.,   -2.,    6.,    6.,   -4.,    4.,    0.,
     e              0.,   -2.,    1.,    4.,    3.,    0.,    0.,   -6./
      data g5/ -30926.,-2318., 5817., -893., 2969.,-1334., 1471.,  728.,
     1           1140.,-1645., -462., 1202.,  119.,  881.,  229.,  891.,
     2            711.,  216.,  601., -163., -426., -130.,  217.,  -70.,
     3           -230.,  326.,  -96.,  226.,   58.,  -28.,  -44., -125.,
     4           -122.,  -69.,   51.,   61.,   54.,    3.,   -9.,   99.,
     5           -238.,   14.,  -40.,  -18.,   39.,   13., -103.,  -52.,
     6             73.,  -54.,  -50.,    3.,  -14.,   27.,  -14.,  -35.,
     7              5.,  -14.,   29.,   19.,  -17.,    6.,  -21.,   11.,
     8              7.,    8.,   -3.,  -15.,   -9.,    6.,    2.,  -14.,
     9              4.,    5.,   -7.,   17.,    7.,   -5.,    8.,  -19.,
     a              8.,   10.,  -20.,    1.,   14.,  -11.,    5.,   12.,
     b             -3.,    1.,   -2.,   -2.,    9.,    2.,   10.,    0.,
     c             -2.,   -1.,    2.,   -3.,   -4.,    2.,    2.,    1.,
     d             -5.,    2.,   -2.,    6.,    6.,   -4.,    4.,    0.,
     e              0.,   -2.,    1.,    4.,    3.,    0.,    0.,   -6./
      data g6/ -30805.,-2316., 5808., -951., 2980.,-1424., 1517.,  644.,
     1           1172.,-1692., -480., 1205.,  133.,  907.,  166.,  896.,
     2            727.,  205.,  584., -195., -422., -109.,  234.,  -90.,
     3           -237.,  327.,  -72.,  218.,   60.,  -32.,  -53., -131.,
     4           -118.,  -74.,   58.,   60.,   53.,    4.,   -9.,  102.,
     5           -242.,   19.,  -32.,  -16.,   32.,    8., -104.,  -46.,
     6             74.,  -54.,  -51.,    4.,  -15.,   25.,  -14.,  -34.,
     7              6.,  -12.,   29.,   18.,  -18.,    6.,  -20.,   11.,
     8              7.,    8.,   -3.,  -15.,   -9.,    5.,    2.,  -14.,
     9              5.,    5.,   -6.,   18.,    8.,   -5.,    8.,  -19.,
     a              8.,   10.,  -20.,    1.,   14.,  -12.,    5.,   12.,
     b             -3.,    1.,   -2.,   -2.,    9.,    3.,   10.,    0.,
     c             -2.,   -2.,    2.,   -3.,   -4.,    2.,    2.,    1.,
     d             -5.,    2.,   -2.,    6.,    6.,   -4.,    4.,    0.,
     e              0.,   -2.,    1.,    4.,    3.,    0.,    0.,   -6./
      data g7/ -30715.,-2306., 5812.,-1018., 2984.,-1520., 1550.,  586.,
     1           1206.,-1740., -494., 1215.,  146.,  918.,  101.,  903.,
     2            744.,  188.,  565., -226., -415.,  -90.,  249., -114.,
     3           -241.,  329.,  -51.,  211.,   64.,  -33.,  -64., -136.,
     4           -115.,  -76.,   64.,   59.,   53.,    4.,   -8.,  104.,
     5           -246.,   25.,  -25.,  -15.,   25.,    4., -106.,  -40.,
     6             74.,  -53.,  -52.,    4.,  -17.,   23.,  -14.,  -33.,
     7              7.,  -11.,   29.,   18.,  -19.,    6.,  -19.,   11.,
     8              7.,    8.,   -3.,  -15.,   -9.,    5.,    1.,  -15.,
     9              6.,    5.,   -6.,   18.,    8.,   -5.,    7.,  -19.,
     a              8.,   10.,  -20.,    1.,   15.,  -12.,    5.,   11.,
     b             -3.,    1.,   -3.,   -2.,    9.,    3.,   11.,    0.,
     c             -2.,   -2.,    2.,   -3.,   -4.,    2.,    2.,    1.,
     d             -5.,    2.,   -2.,    6.,    6.,   -4.,    4.,    0.,
     e              0.,   -1.,    2.,    4.,    3.,    0.,    0.,   -6./
      data g8/ -30654.,-2292., 5821.,-1106., 2981.,-1614., 1566.,  528.,
     1           1240.,-1790., -499., 1232.,  163.,  916.,   43.,  914.,
     2            762.,  169.,  550., -252., -405.,  -72.,  265., -141.,
     3           -241.,  334.,  -33.,  208.,   71.,  -33.,  -75., -141.,
     4           -113.,  -76.,   69.,   57.,   54.,    4.,   -7.,  105.,
     5           -249.,   33.,  -18.,  -15.,   18.,    0., -107.,  -33.,
     6             74.,  -53.,  -52.,    4.,  -18.,   20.,  -14.,  -31.,
     7              7.,   -9.,   29.,   17.,  -20.,    5.,  -19.,   11.,
     8              7.,    8.,   -3.,  -14.,  -10.,    5.,    1.,  -15.,
     9              6.,    5.,   -5.,   19.,    9.,   -5.,    7.,  -19.,
     a              8.,   10.,  -21.,    1.,   15.,  -12.,    5.,   11.,
     b             -3.,    1.,   -3.,   -2.,    9.,    3.,   11.,    1.,
     c             -2.,   -2.,    2.,   -3.,   -4.,    2.,    2.,    1.,
     d             -5.,    2.,   -2.,    6.,    6.,   -4.,    4.,    0.,
     e              0.,   -1.,    2.,    4.,    3.,    0.,    0.,   -6./
      data g9/ -30594.,-2285., 5810.,-1244., 2990.,-1702., 1578.,  477.,
     1           1282.,-1834., -499., 1255.,  186.,  913.,  -11.,  944.,
     2            776.,  144.,  544., -276., -421.,  -55.,  304., -178.,
     3           -253.,  346.,  -12.,  194.,   95.,  -20.,  -67., -142.,
     4           -119.,  -82.,   82.,   59.,   57.,    6.,    6.,  100.,
     5           -246.,   16.,  -25.,   -9.,   21.,  -16., -104.,  -39.,
     6             70.,  -40.,  -45.,    0.,  -18.,    0.,    2.,  -29.,
     7              6.,  -10.,   28.,   15.,  -17.,   29.,  -22.,   13.,
     8              7.,   12.,   -8.,  -21.,   -5.,  -12.,    9.,   -7.,
     9              7.,    2.,  -10.,   18.,    7.,    3.,    2.,  -11.,
     a              5.,  -21.,  -27.,    1.,   17.,  -11.,   29.,    3.,
     b             -9.,   16.,    4.,   -3.,    9.,   -4.,    6.,   -3.,
     c              1.,   -4.,    8.,   -3.,   11.,    5.,    1.,    1.,
     d              2.,  -20.,   -5.,   -1.,   -1.,   -6.,    8.,    6.,
     e             -1.,   -4.,   -3.,   -2.,    5.,    0.,   -2.,   -2./
      data ga/ -30554.,-2250., 5815.,-1341., 2998.,-1810., 1576.,  381.,
     1           1297.,-1889., -476., 1274.,  206.,  896.,  -46.,  954.,
     2            792.,  136.,  528., -278., -408.,  -37.,  303., -210.,
     3           -240.,  349.,    3.,  211.,  103.,  -20.,  -87., -147.,
     4           -122.,  -76.,   80.,   54.,   57.,   -1.,    4.,   99.,
     5           -247.,   33.,  -16.,  -12.,   12.,  -12., -105.,  -30.,
     6             65.,  -55.,  -35.,    2.,  -17.,    1.,    0.,  -40.,
     7             10.,   -7.,   36.,    5.,  -18.,   19.,  -16.,   22.,
     8             15.,    5.,   -4.,  -22.,   -1.,    0.,   11.,  -21.,
     9             15.,   -8.,  -13.,   17.,    5.,   -4.,   -1.,  -17.,
     a              3.,   -7.,  -24.,   -1.,   19.,  -25.,   12.,   10.,
     b              2.,    5.,    2.,   -5.,    8.,   -2.,    8.,    3.,
     c            -11.,    8.,   -7.,   -8.,    4.,   13.,   -1.,   -2.,
     d             13.,  -10.,   -4.,    2.,    4.,   -3.,   12.,    6.,
     e              3.,   -3.,    2.,    6.,   10.,   11.,    3.,    8./
      data gb/ -30500.,-2215., 5820.,-1440., 3003.,-1898., 1581.,  291.,
     1           1302.,-1944., -462., 1288.,  216.,  882.,  -83.,  958.,
     2            796.,  133.,  510., -274., -397.,  -23.,  290., -230.,
     3           -229.,  360.,   15.,  230.,  110.,  -23.,  -98., -152.,
     4           -121.,  -69.,   78.,   47.,   57.,   -9.,    3.,   96.,
     5           -247.,   48.,   -8.,  -16.,    7.,  -12., -107.,  -24.,
     6             65.,  -56.,  -50.,    2.,  -24.,   10.,   -4.,  -32.,
     7              8.,  -11.,   28.,    9.,  -20.,   18.,  -18.,   11.,
     8              9.,   10.,   -6.,  -15.,  -14.,    5.,    6.,  -23.,
     9             10.,    3.,   -7.,   23.,    6.,   -4.,    9.,  -13.,
     a              4.,    9.,  -11.,   -4.,   12.,   -5.,    7.,    2.,
     b              6.,    4.,   -2.,    1.,   10.,    2.,    7.,    2.,
     c             -6.,    5.,    5.,   -3.,   -5.,   -4.,   -1.,    0.,
     d              2.,   -8.,   -3.,   -2.,    7.,   -4.,    4.,    1.,
     e             -2.,   -3.,    6.,    7.,   -2.,   -1.,    0.,   -3./
      data gc/ -30421.,-2169., 5791.,-1555., 3002.,-1967., 1590.,  206.,
     1           1302.,-1992., -414., 1289.,  224.,  878., -130.,  957.,
     2            800.,  135.,  504., -278., -394.,    3.,  269., -255.,
     3           -222.,  362.,   16.,  242.,  125.,  -26., -117., -156.,
     4           -114.,  -63.,   81.,   46.,   58.,  -10.,    1.,   99.,
     5           -237.,   60.,   -1.,  -20.,   -2.,  -11., -113.,  -17.,
     6             67.,  -56.,  -55.,    5.,  -28.,   15.,   -6.,  -32.,
     7              7.,   -7.,   23.,   17.,  -18.,    8.,  -17.,   15.,
     8              6.,   11.,   -4.,  -14.,  -11.,    7.,    2.,  -18.,
     9             10.,    4.,   -5.,   23.,   10.,    1.,    8.,  -20.,
     a              4.,    6.,  -18.,    0.,   12.,   -9.,    2.,    1.,
     b              0.,    4.,   -3.,   -1.,    9.,   -2.,    8.,    3.,
     c              0.,   -1.,    5.,    1.,   -3.,    4.,    4.,    1.,
     d              0.,    0.,   -1.,    2.,    4.,   -5.,    6.,    1.,
     e              1.,   -1.,   -1.,    6.,    2.,    0.,    0.,   -7./
      data gd/ -30334.,-2119., 5776.,-1662., 2997.,-2016., 1594.,  114.,
     1           1297.,-2038., -404., 1292.,  240.,  856., -165.,  957.,
     2            804.,  148.,  479., -269., -390.,   13.,  252., -269.,
     3           -219.,  358.,   19.,  254.,  128.,  -31., -126., -157.,
     4            -97.,  -62.,   81.,   45.,   61.,  -11.,    8.,  100.,
     5           -228.,   68.,    4.,  -32.,    1.,   -8., -111.,   -7.,
     6             75.,  -57.,  -61.,    4.,  -27.,   13.,   -2.,  -26.,
     7              6.,   -6.,   26.,   13.,  -23.,    1.,  -12.,   13.,
     8              5.,    7.,   -4.,  -12.,  -14.,    9.,    0.,  -16.,
     9              8.,    4.,   -1.,   24.,   11.,   -3.,    4.,  -17.,
     a              8.,   10.,  -22.,    2.,   15.,  -13.,    7.,   10.,
     b             -4.,   -1.,   -5.,   -1.,   10.,    5.,   10.,    1.,
     c             -4.,   -2.,    1.,   -2.,   -3.,    2.,    2.,    1.,
     d             -5.,    2.,   -2.,    6.,    4.,   -4.,    4.,    0.,
     e              0.,   -2.,    2.,    3.,    2.,    0.,    0.,   -6./
      data ge/ -30220.,-2068., 5737.,-1781., 3000.,-2047., 1611.,   25.,
     1           1287.,-2091., -366., 1278.,  251.,  838., -196.,  952.,
     2            800.,  167.,  461., -266., -395.,   26.,  234., -279.,
     3           -216.,  359.,   26.,  262.,  139.,  -42., -139., -160.,
     4            -91.,  -56.,   83.,   43.,   64.,  -12.,   15.,  100.,
     5           -212.,   72.,    2.,  -37.,    3.,   -6., -112.,    1.,
     6             72.,  -57.,  -70.,    1.,  -27.,   14.,   -4.,  -22.,
     7              8.,   -2.,   23.,   13.,  -23.,   -2.,  -11.,   14.,
     8              6.,    7.,   -2.,  -15.,  -13.,    6.,   -3.,  -17.,
     9              5.,    6.,    0.,   21.,   11.,   -6.,    3.,  -16.,
     a              8.,   10.,  -21.,    2.,   16.,  -12.,    6.,   10.,
     b             -4.,   -1.,   -5.,    0.,   10.,    3.,   11.,    1.,
     c             -2.,   -1.,    1.,   -3.,   -3.,    1.,    2.,    1.,
     d             -5.,    3.,   -1.,    4.,    6.,   -4.,    4.,    0.,
     e              1.,   -1.,    0.,    3.,    3.,    1.,   -1.,   -4./
      data gf/ -30100.,-2013., 5675.,-1902., 3010.,-2067., 1632.,  -68.,
     1           1276.,-2144., -333., 1260.,  262.,  830., -223.,  946.,
     2            791.,  191.,  438., -265., -405.,   39.,  216., -288.,
     3           -218.,  356.,   31.,  264.,  148.,  -59., -152., -159.,
     4            -83.,  -49.,   88.,   45.,   66.,  -13.,   28.,   99.,
     5           -198.,   75.,    1.,  -41.,    6.,   -4., -111.,   11.,
     6             71.,  -56.,  -77.,    1.,  -26.,   16.,   -5.,  -14.,
     7             10.,    0.,   22.,   12.,  -23.,   -5.,  -12.,   14.,
     8              6.,    6.,   -1.,  -16.,  -12.,    4.,   -8.,  -19.,
     9              4.,    6.,    0.,   18.,   10.,  -10.,    1.,  -17.,
     a              7.,   10.,  -21.,    2.,   16.,  -12.,    7.,   10.,
     b             -4.,   -1.,   -5.,   -1.,   10.,    4.,   11.,    1.,
     c             -3.,   -2.,    1.,   -3.,   -3.,    1.,    2.,    1.,
     d             -5.,    3.,   -2.,    4.,    5.,   -4.,    4.,   -1.,
     e              1.,   -1.,    0.,    3.,    3.,    1.,   -1.,   -5./
      data gg/ -29992.,-1956., 5604.,-1997., 3027.,-2129., 1663., -200.,
     1           1281.,-2180., -336., 1251.,  271.,  833., -252.,  938.,
     2            782.,  212.,  398., -257., -419.,   53.,  199., -297.,
     3           -218.,  357.,   46.,  261.,  150.,  -74., -151., -162.,
     4            -78.,  -48.,   92.,   48.,   66.,  -15.,   42.,   93.,
     5           -192.,   71.,    4.,  -43.,   14.,   -2., -108.,   17.,
     6             72.,  -59.,  -82.,    2.,  -27.,   21.,   -5.,  -12.,
     7             16.,    1.,   18.,   11.,  -23.,   -2.,  -10.,   18.,
     8              6.,    7.,    0.,  -18.,  -11.,    4.,   -7.,  -22.,
     9              4.,    9.,    3.,   16.,    6.,  -13.,   -1.,  -15.,
     a              5.,   10.,  -21.,    1.,   16.,  -12.,    9.,    9.,
     b             -5.,   -3.,   -6.,   -1.,    9.,    7.,   10.,    2.,
     c             -6.,   -5.,    2.,   -4.,   -4.,    1.,    2.,    0.,
     d             -5.,    3.,   -2.,    6.,    5.,   -4.,    3.,    0.,
     e              1.,   -1.,    2.,    4.,    3.,    0.,    0.,   -6./
      data gi/ -29873.,-1905., 5500.,-2072., 3044.,-2197., 1687., -306.,
     1           1296.,-2208., -310., 1247.,  284.,  829., -297.,  936.,
     2            780.,  232.,  361., -249., -424.,   69.,  170., -297.,
     3           -214.,  355.,   47.,  253.,  150.,  -93., -154., -164.,
     4            -75.,  -46.,   95.,   53.,   65.,  -16.,   51.,   88.,
     5           -185.,   69.,    4.,  -48.,   16.,   -1., -102.,   21.,
     6             74.,  -62.,  -83.,    3.,  -27.,   24.,   -2.,   -6.,
     7             20.,    4.,   17.,   10.,  -23.,    0.,   -7.,   21.,
     8              6.,    8.,    0.,  -19.,  -11.,    5.,   -9.,  -23.,
     9              4.,   11.,    4.,   14.,    4.,  -15.,   -4.,  -11.,
     a              5.,   10.,  -21.,    1.,   15.,  -12.,    9.,    9.,
     b             -6.,   -3.,   -6.,   -1.,    9.,    7.,    9.,    1.,
     c             -7.,   -5.,    2.,   -4.,   -4.,    1.,    3.,    0.,
     d             -5.,    3.,   -2.,    6.,    5.,   -4.,    3.,    0.,
     e              1.,   -1.,    2.,    4.,    3.,    0.,    0.,   -6./
      data gj/ -29775.,-1848., 5406.,-2131., 3059.,-2279., 1686., -373.,
     1           1314.,-2239., -284., 1248.,  293.,  802., -352.,  939.,
     2            780.,  247.,  325., -240., -423.,   84.,  141., -299.,
     3           -214.,  353.,   46.,  245.,  154., -109., -153., -165.,
     4            -69.,  -36.,   97.,   61.,   65.,  -16.,   59.,   82.,
     5           -178.,   69.,    3.,  -52.,   18.,    1.,  -96.,   24.,
     6             77.,  -64.,  -80.,    2.,  -26.,   26.,    0.,   -1.,
     7             21.,    5.,   17.,    9.,  -23.,    0.,   -4.,   23.,
     8              5.,   10.,   -1.,  -19.,  -10.,    6.,  -12.,  -22.,
     9              3.,   12.,    4.,   12.,    2.,  -16.,   -6.,  -10.,
     a              4.,    9.,  -20.,    1.,   15.,  -12.,   11.,    9.,
     b             -7.,   -4.,   -7.,   -2.,    9.,    7.,    8.,    1.,
     c             -7.,   -6.,    2.,   -3.,   -4.,    2.,    2.,    1.,
     d             -5.,    3.,   -2.,    6.,    4.,   -4.,    3.,    0.,
     e              1.,   -2.,    3.,    3.,    3.,   -1.,    0.,   -6./
      data gk/ -29692.,-1784., 5306.,-2200., 3070.,-2366., 1681., -413.,
     1           1335.,-2267., -262., 1249.,  302.,  759., -427.,  940.,
     2            780.,  262.,  290., -236., -418.,   97.,  122., -306.,
     3           -214.,  352.,   46.,  235.,  165., -118., -143., -166.,
     4            -55.,  -17.,  107.,   68.,   67.,  -17.,   68.,   72.,
     5           -170.,   67.,   -1.,  -58.,   19.,    1.,  -93.,   36.,
     6             77.,  -72.,  -69.,    1.,  -25.,   28.,    4.,    5.,
     7             24.,    4.,   17.,    8.,  -24.,   -2.,   -6.,   25.,
     8              6.,   11.,   -6.,  -21.,   -9.,    8.,  -14.,  -23.,
     9              9.,   15.,    6.,   11.,   -5.,  -16.,   -7.,   -4.,
     a              4.,    9.,  -20.,    3.,   15.,  -10.,   12.,    8.,
     b             -6.,   -8.,   -8.,   -1.,    8.,   10.,    5.,   -2.,
     c             -8.,   -8.,    3.,   -3.,   -6.,    1.,    2.,    0.,
     d             -4.,    4.,   -1.,    5.,    4.,   -5.,    2.,   -1.,
     e              2.,   -2.,    5.,    1.,    1.,   -2.,    0.,   -7.,
     f           75*0./                                                 
      data gl/ -29619.4,-1728.2, 5186.1,-2267.7, 3068.4,-2481.6, 1670.9,
     1           -458.0, 1339.6,-2288.0, -227.6, 1252.1,  293.4,  714.5,
     2           -491.1,  932.3,  786.8,  272.6,  250.0, -231.9, -403.0,
     3            119.8,  111.3, -303.8, -218.8,  351.4,   43.8,  222.3,
     4            171.9, -130.4, -133.1, -168.6,  -39.3,  -12.9,  106.3,
     5             72.3,   68.2,  -17.4,   74.2,   63.7, -160.9,   65.1,
     6             -5.9,  -61.2,   16.9,    0.7,  -90.4,   43.8,   79.0,
     7            -74.0,  -64.6,    0.0,  -24.2,   33.3,    6.2,    9.1,
     8             24.0,    6.9,   14.8,    7.3,  -25.4,   -1.2,   -5.8,
     9             24.4,    6.6,   11.9,   -9.2,  -21.5,   -7.9,    8.5,
     a            -16.6,  -21.5,    9.1,   15.5,    7.0,    8.9,   -7.9,
     b            -14.9,   -7.0,   -2.1,    5.0,    9.4,  -19.7,    3.0,
     c             13.4,   -8.4,   12.5,    6.3,   -6.2,   -8.9,   -8.4,
     d             -1.5,    8.4,    9.3,    3.8,   -4.3,   -8.2,   -8.2,
     e              4.8,   -2.6,   -6.0,    1.7,    1.7,    0.0,   -3.1,
     f              4.0,   -0.5,    4.9,    3.7,   -5.9,    1.0,   -1.2,
     g              2.0,   -2.9,    4.2,    0.2,    0.3,   -2.2,   -1.1,
     h             -7.4,    2.7,   -1.7,    0.1,   -1.9,    1.3,    1.5,
     i             -0.9,   -0.1,   -2.6,    0.1,    0.9,   -0.7,   -0.7,
     j              0.7,   -2.8,    1.7,   -0.9,    0.1,   -1.2,    1.2,
     k             -1.9,    4.0,   -0.9,   -2.2,   -0.3,   -0.4,    0.2,
     l              0.3,    0.9,    2.5,   -0.2,   -2.6,    0.9,    0.7,
     m             -0.5,    0.3,    0.3,    0.0,   -0.3,    0.0,   -0.4,
     n              0.3,   -0.1,   -0.9,   -0.2,   -0.4,   -0.4,    0.8,
     o             -0.2,   -0.9,   -0.9,    0.3,    0.2,    0.1,    1.8,
     p             -0.4,   -0.4,    1.3,   -1.0,   -0.4,   -0.1,    0.7,
     q              0.7,   -0.4,    0.3,    0.3,    0.6,   -0.1,    0.3,
     r              0.4,   -0.2,    0.0,   -0.5,    0.1,   -0.9/        
      data gm/-29554.63,-1669.05, 5077.99,-2337.24, 3047.69,-2594.50,   
     1          1657.76, -515.43, 1336.30,-2305.83, -198.86, 1246.39,   
     2           269.72,  672.51, -524.72,  920.55,  797.96,  282.07,   
     3           210.65, -225.23, -379.86,  145.15,  100.00, -305.36,   
     4          -227.00,  354.41,   42.72,  208.95,  180.25, -136.54,   
     5          -123.45, -168.05,  -19.57,  -13.55,  103.85,   73.60,   
     6            69.56,  -20.33,   76.74,   54.75, -151.34,   63.63,   
     7           -14.58,  -63.53,   14.58,    0.24,  -86.36,   50.94,   
     8            79.88,  -74.46,  -61.14,   -1.65,  -22.57,   38.73,   
     9             6.82,   12.30,   25.35,    9.37,   10.93,    5.42,   
     a           -26.32,    1.94,   -4.64,   24.80,    7.62,   11.20,   
     b           -11.73,  -20.88,   -6.88,    9.83,  -18.11,  -19.71,   
     c            10.17,   16.22,    9.36,    7.61,  -11.25,  -12.76,   
     d            -4.87,   -0.06,    5.58,    9.76,  -20.11,    3.58,   
     e            12.69,   -6.94,   12.67,    5.01,   -6.72,  -10.76,   
     f            -8.16,   -1.25,    8.10,    8.76,    2.92,   -6.66,   
     g            -7.73,   -9.22,    6.01,   -2.17,   -6.12,    2.19,   
     h             1.42,    0.10,   -2.35,    4.46,   -0.15,    4.76,   
     i             3.06,   -6.58,    0.29,   -1.01,    2.06,   -3.47,   
     j             3.77,   -0.86,   -0.21,   -2.31,   -2.09,   -7.93,   
     k             2.95,   -1.60,    0.26,   -1.88,    1.44,    1.44,   
     l            -0.77,   -0.31,   -2.27,    0.29,    0.90,   -0.79,   
     m            -0.58,    0.53,   -2.69,    1.80,   -1.08,    0.16,   
     n            -1.58,    0.96,   -1.90,    3.99,   -1.39,   -2.15,   
     o            -0.29,   -0.55,    0.21,    0.23,    0.89,    2.38,   
     p            -0.38,   -2.63,    0.96,    0.61,   -0.30,    0.40,   
     q             0.46,    0.01,   -0.35,    0.02,   -0.36,    0.28,   
     r             0.08,   -0.87,   -0.49,   -0.34,   -0.08,    0.88,   
     s            -0.16,   -0.88,   -0.76,    0.30,    0.33,    0.28,   
     t             1.72,   -0.43,   -0.54,    1.18,   -1.07,   -0.37,   
     u            -0.04,    0.75,    0.63,   -0.26,    0.21,    0.35,   
     v             0.53,   -0.05,    0.38,    0.41,   -0.22,   -0.10,   
     w            -0.57,   -0.18,   -0.82/                              
      data gp/-29496.57,-1586.42, 4944.26,-2396.06, 3026.34,-2708.54,   
     1          1668.17, -575.73, 1339.85,-2326.54, -160.40, 1232.10,   
     2           251.75,  633.73, -537.03,  912.66,  808.97,  286.48,   
     3           166.58, -211.03, -356.83,  164.46,   89.40, -309.72,   
     4          -230.87,  357.29,   44.58,  200.26,  189.01, -141.05,   
     5          -118.06, -163.17,   -0.01,   -8.03,  101.04,   72.78,   
     6            68.69,  -20.90,   75.92,   44.18, -141.40,   61.54,   
     7           -22.83,  -66.26,   13.10,    3.02,  -78.09,   55.40,   
     8            80.44,  -75.00,  -57.80,   -4.55,  -21.20,   45.24,   
     9             6.54,   14.00,   24.96,   10.46,    7.03,    1.64,   
     a           -27.61,    4.92,   -3.28,   24.41,    8.21,   10.84,   
     b           -14.50,  -20.03,   -5.59,   11.83,  -19.34,  -17.41,   
     c            11.61,   16.71,   10.85,    6.96,  -14.05,  -10.74,   
     d            -3.54,    1.64,    5.50,    9.45,  -20.54,    3.45,   
     e            11.51,   -5.27,   12.75,    3.13,   -7.14,  -12.38,   
     f            -7.42,   -0.76,    7.97,    8.43,    2.14,   -8.42,   
     g            -6.08,  -10.08,    7.01,   -1.94,   -6.24,    2.73,   
     h             0.89,   -0.10,   -1.07,    4.71,   -0.16,    4.44,   
     i             2.45,   -7.22,   -0.33,   -0.96,    2.13,   -3.95,   
     j             3.09,   -1.99,   -1.03,   -1.97,   -2.80,   -8.31,   
     k             3.05,   -1.48,    0.13,   -2.03,    1.67,    1.65,   
     l            -0.66,   -0.51,   -1.76,    0.54,    0.85,   -0.79,   
     m            -0.39,    0.37,   -2.51,    1.79,   -1.27,    0.12,   
     n            -2.11,    0.75,   -1.94,    3.75,   -1.86,   -2.12,   
     o            -0.21,   -0.87,    0.30,    0.27,    1.04,    2.13,   
     p            -0.63,   -2.49,    0.95,    0.49,   -0.11,    0.59,   
     q             0.52,    0.00,   -0.39,    0.13,   -0.37,    0.27,   
     r             0.21,   -0.86,   -0.77,   -0.23,    0.04,    0.87,   
     s            -0.09,   -0.89,   -0.87,    0.31,    0.30,    0.42,   
     t             1.66,   -0.45,   -0.59,    1.08,   -1.14,   -0.31,   
     u            -0.07,    0.78,    0.54,   -0.18,    0.10,    0.38,   
     v             0.49,    0.02,    0.44,    0.42,   -0.25,   -0.26,   
     w            -0.53,   -0.26,   -0.79/                              
      data gq/-29442.0,-1501.0, 4797.1,-2445.1, 3012.9,-2845.6, 1676.7, 
     1          -641.9, 1350.7,-2352.3, -115.3, 1225.6,  244.9,  582.0, 
     2          -538.4,  907.6,  813.7,  283.3,  120.4, -188.7, -334.9, 
     3           180.9,   70.4, -329.5, -232.6,  360.1,   47.3,  192.4, 
     4           197.0, -140.9, -119.3, -157.5,   16.0,    4.1,  100.2, 
     5            70.0,   67.7,  -20.8,   72.7,   33.2, -129.9,   58.9, 
     6           -28.9,  -66.7,   13.2,    7.3,  -70.9,   62.6,   81.6, 
     7           -76.1,  -54.1,   -6.8,  -19.5,   51.8,    5.7,   15.0, 
     8            24.4,    9.4,    3.4,   -2.8,  -27.4,    6.8,   -2.2, 
     9            24.2,    8.8,   10.1,  -16.9,  -18.3,   -3.2,   13.3, 
     a           -20.6,  -14.6,   13.4,   16.2,   11.7,    5.7,  -15.9, 
     b            -9.1,   -2.0,    2.1,    5.4,    8.8,  -21.6,    3.1, 
     c            10.8,   -3.3,   11.8,    0.7,   -6.8,  -13.3,   -6.9, 
     d            -0.1,    7.8,    8.7,    1.0,   -9.1,   -4.0,  -10.5, 
     e             8.4,   -1.9,   -6.3,    3.2,    0.1,   -0.4,    0.5, 
     f             4.6,   -0.5,    4.4,    1.8,   -7.9,   -0.7,   -0.6, 
     g             2.1,   -4.2,    2.4,   -2.8,   -1.8,   -1.2,   -3.6, 
     h            -8.7,    3.1,   -1.5,   -0.1,   -2.3,    2.0,    2.0, 
     i            -0.7,   -0.8,   -1.1,    0.6,    0.8,   -0.7,   -0.2, 
     j             0.2,   -2.2,    1.7,   -1.4,   -0.2,   -2.5,    0.4, 
     k            -2.0,    3.5,   -2.4,   -1.9,   -0.2,   -1.1,    0.4, 
     l             0.4,    1.2,    1.9,   -0.8,   -2.2,    0.9,    0.3, 
     m             0.1,    0.7,    0.5,   -0.1,   -0.3,    0.3,   -0.4, 
     n             0.2,    0.2,   -0.9,   -0.9,   -0.1,    0.0,    0.7, 
     o             0.0,   -0.9,   -0.9,    0.4,    0.4,    0.5,    1.6, 
     p            -0.5,   -0.5,    1.0,   -1.2,   -0.2,   -0.1,    0.8, 
     q             0.4,   -0.1,   -0.1,    0.3,    0.4,    0.1,    0.5, 
     r             0.5,   -0.3,   -0.4,   -0.4,   -0.3,   -0.8/         
      data gr/    10.3,   18.1,  -26.6,   -8.7,   -3.3,  -27.4,    2.1, 
     1           -14.1,    3.4,   -5.5,    8.2,   -0.7,   -0.4,  -10.1, 
     2             1.8,   -0.7,    0.2,   -1.3,   -9.1,    5.3,    4.1, 
     3             2.9,   -4.3,   -5.2,   -0.2,    0.5,    0.6,   -1.3, 
     4             1.7,   -0.1,   -1.2,    1.4,    3.4,    3.9,    0.0, 
     5            -0.3,   -0.1,    0.0,   -0.7,   -2.1,    2.1,   -0.7, 
     6            -1.2,    0.2,    0.3,    0.9,    1.6,    1.0,    0.3, 
     7            -0.2,    0.8,   -0.5,    0.4,    1.3,   -0.2,    0.1, 
     8            -0.3,   -0.6,   -0.6,   -0.8,    0.1,    0.2,   -0.2, 
     9             0.2,    0.0,   -0.3,   -0.6,    0.3,    0.5,    0.1, 
     a            -0.2,    0.5,    0.4,   -0.2,    0.1,   -0.3,   -0.4, 
     b             0.3,    0.3,    0.0,115*0.0/                         

c
c     set initial values
c
      x     = 0.0
      y     = 0.0
      z     = 0.0
c *** oce: give several fn, three and gn initial values, to prevent
c *** oce: warnings issued during compilation by R. (It seems likely
c *** oce: that the original code was either using knowledge that
c *** oce: things would always be assigned, or was using the
c *** oce: zero-initialization property of fortran.)
      fn = 0.0
      three = 0.0
      gn = 0.0

      if (date.lt.1900.0.or.date.gt.2025.0) go to 11
c      if (date.gt.2020.0) write (6,960) date
c  960 format (/' This version of the IGRF is intended for use up',
c     1        ' to 2020.0.'/' values for',f9.3,' will be computed',
c     2        ' but may be of reduced accuracy'/)
      if (date.ge.2015.0) go to 1
      t     = 0.2*(date - 1900.0)                                             
c *** oce change: next line gets an int() to silence gfortran warning
      ll    = int(t)
      one   = ll
      t     = t - one
c
c     SH models before 1995.0 are only to degree 10
c
      if (date.lt.1995.0) then
       nmx   = 10
       nc    = nmx*(nmx+2)
       ll    = nc*ll
       kmx   = (nmx+1)*(nmx+2)/2
      else
       nmx   = 13
       nc    = nmx*(nmx+2)
c *** oce change: next line gets an int() to silence gfortran warning
       ll    = int(0.2*(date - 1995.0))
c
c     19 is the number of SH models that extend to degree 10
c
       ll    = 120*19 + nc*ll
       kmx   = (nmx+1)*(nmx+2)/2
      endif
      tc    = 1.0 - t
      if (isv.eq.1) then
       tc = -0.2
       t = 0.2
      end if
      go to 2
c
    1 t     = date - 2015.0
      tc    = 1.0
      if (isv.eq.1) then
       t = 1.0
       tc = 0.0
      end if
c
c     pointer for last coefficient in pen-ultimate set of MF coefficients...
c
      ll    = 3060
      nmx   = 13
      nc    = nmx*(nmx+2)
      kmx   = (nmx+1)*(nmx+2)/2
    2 r     = alt
      one   = colat*0.017453292
      ct    = cos(one)
      st    = sin(one)
      one   = elong*0.017453292
      cl(1) = cos(one)
      sl(1) = sin(one)
      cd    = 1.0
      sd    = 0.0
      l     = 1
      m     = 1
      n     = 0
      if (itype.eq.2) go to 3
c
c     conversion from geodetic to geocentric coordinates 
c     (using the WGS84 spheroid)
c
      a2    = 40680631.6
      b2    = 40408296.0
      one   = a2*st*st
      two   = b2*ct*ct
      three = one + two
      rho   = sqrt(three)
      r     = sqrt(alt*(alt + 2.0*rho) + (a2*one + b2*two)/three)
      cd    = (alt + rho)/r
      sd    = (a2 - b2)/rho*ct*st/r
      one   = ct
      ct    = ct*cd -  st*sd
      st    = st*cd + one*sd
c
    3 ratio = 6371.2/r
      rr    = ratio*ratio
c
c     computation of Schmidt quasi-normal coefficients p and x(=q)
c
      p(1)  = 1.0
      p(3)  = st
      q(1)  = 0.0
      q(3)  =  ct
      do k=2,kmx
       if (n.ge.m) go to 4
       m     = 0
       n     = n + 1
       rr    = rr*ratio
       fn    = n
       gn    = n - 1
    4  fm    = m
       if (m.ne.n) go to 5
       if (k.eq.3) go to 6
       one   = sqrt(1.0 - 0.5/fm)
       j     = k - n - 1
       p(k)  = one*st*p(j)
       q(k)  = one*(st*q(j) + ct*p(j))
       cl(m) = cl(m-1)*cl(1) - sl(m-1)*sl(1)
       sl(m) = sl(m-1)*cl(1) + cl(m-1)*sl(1)
       go to 6                                                           
    5  gmm    = m*m
       one   = sqrt(fn*fn - gmm)
       two   = sqrt(gn*gn - gmm)/one
       three = (fn + gn)/one
       i     = k - n
       j     = i - n + 1
       p(k)  = three*ct*p(i) - two*p(j)
       q(k)  = three*(ct*q(i) - st*p(i)) - two*q(j)
c
c     synthesis of x, y and z in geocentric coordinates
c
    6  lm    = ll + l
       one   = (tc*gh(lm) + t*gh(lm+nc))*rr                                     
       if (m.eq.0) go to 9                                                      
       two   = (tc*gh(lm+1) + t*gh(lm+nc+1))*rr
       three = one*cl(m) + two*sl(m)
       x     = x + three*q(k)
       z     = z - (fn + 1.0)*three*p(k)
       if (st.eq.0.0) go to 7
       y     = y + (one*sl(m) - two*cl(m))*fm*p(k)/st
       go to 8
    7  y     = y + (one*sl(m) - two*cl(m))*q(k)*ct
    8  l     = l + 2
       go to 10
    9  x     = x + one*q(k)
       z     = z - (fn + 1.0)*one*p(k)
       l     = l + 1
   10  m     = m + 1
      end do
c
c     conversion to coordinate system specified by itype
c
      one   = x
      x     = x*cd +   z*sd
      z     = z*cd - one*sd
      f     = sqrt(x*x + y*y + z*z)
c
      return
c
c     error return if date out of bounds
c
   11 f     = 1.0d8
c      write (6,961) date
c  961 format (/' This subroutine will not work with a date of',
c     1        f9.3,'.  Date must be in the range 1900.0.ge.date',
c     2        '.le.2025.0. On return f = 1.0d8., x = y = z = 0.')
      return
      end

