% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{utm2lonlat}
\alias{utm2lonlat}
\title{Convert UTM to Longitude and Latitude}
\usage{
utm2lonlat(easting, northing, zone = 1, hemisphere = "N", km = FALSE)
}
\arguments{
\item{easting}{easting coordinate (in km or m, depending on value of
\code{km}).  Alternatively, a list containing items named \code{easting},
\code{northing}, and \code{zone}, in which case these are taken from the
list and the arguments named \code{northing}, \code{zone} and are ignored.}

\item{northing}{northing coordinate (in km or m, depending on value of
\code{km}).}

\item{zone}{UTM zone}

\item{hemisphere}{indication of hemisphere; \code{"N"} for North, anything
else for South.}

\item{km}{logical value indicating whether \code{easting} and
\code{northing} are in kilometers or meters.}
}
\value{
A list containing \code{longitude} and \code{latitude}.
}
\description{
Convert UTM to Longitude and Latitude
}
\examples{
library(oce)
## Cape Split, in the Minas Basin of the Bay of Fundy
utm2lonlat(852863, 5029997, 19)

}
\references{
\url{https://en.wikipedia.org/wiki/Universal_Transverse_Mercator_coordinate_system},
downloaded May 31, 2014.
}
\seealso{
\code{\link[=lonlat2utm]{lonlat2utm()}} does the inverse operation.  For general
projections and their inverses, use \code{\link[=lonlat2map]{lonlat2map()}} and
\code{\link[=map2lonlat]{map2lonlat()}}.

Other functions related to maps: 
\code{\link{formatPosition}()},
\code{\link{lonlat2map}()},
\code{\link{lonlat2utm}()},
\code{\link{map2lonlat}()},
\code{\link{mapArrows}()},
\code{\link{mapAxis}()},
\code{\link{mapContour}()},
\code{\link{mapCoordinateSystem}()},
\code{\link{mapDirectionField}()},
\code{\link{mapGrid}()},
\code{\link{mapImage}()},
\code{\link{mapLines}()},
\code{\link{mapLocator}()},
\code{\link{mapLongitudeLatitudeXY}()},
\code{\link{mapPlot}()},
\code{\link{mapPoints}()},
\code{\link{mapPolygon}()},
\code{\link{mapScalebar}()},
\code{\link{mapText}()},
\code{\link{mapTissot}()},
\code{\link{oceCRS}()},
\code{\link{shiftLongitude}()},
\code{\link{usrLonLat}()}
}
\author{
Dan Kelley
}
\concept{functions related to maps}
