% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{oceFilter}
\alias{oceFilter}
\alias{oce.filter}
\title{Filter a Time Series}
\usage{
oceFilter(x, a = 1, b, zero.phase = FALSE)
}
\arguments{
\item{x}{a vector of numeric values, to be filtered as a time series.}

\item{a}{a vector of numeric values, giving the \eqn{a}{a} coefficients (see
\dQuote{Details}).}

\item{b}{a vector of numeric values, giving the \eqn{b}{b} coefficients (see
\dQuote{Details}).}

\item{zero.phase}{boolean, set to \code{TRUE} to run the filter forwards,
and then backwards, thus removing any phase shifts associated with the
filter.}
}
\value{
A numeric vector of the filtered results, \eqn{y}{y}, as denoted in
\dQuote{Details}.
}
\description{
Filter a time-series, possibly recursively
}
\details{
The filter is defined as e.g.  \eqn{y[i]=b[1]*x[i] + }{y[i]=b[1]*x[i] +
b[2]*x[i-1] + b[3]*x[i-2] + ... - a[2]*y[i-1] - a[3]*y[i-2] - a[4]*y[i-3] -
...}\eqn{ b[2]*x[i-1] + b[3]*x[i-2] + ... - a[2]*y[i-1] - a[3]*y[i-2] -
}{y[i]=b[1]*x[i] + b[2]*x[i-1] + b[3]*x[i-2] + ... - a[2]*y[i-1] -
a[3]*y[i-2] - a[4]*y[i-3] - ...}\eqn{ a[4]*y[i-3] - ...}{y[i]=b[1]*x[i] +
b[2]*x[i-1] + b[3]*x[i-2] + ... - a[2]*y[i-1] - a[3]*y[i-2] - a[4]*y[i-3] -
...}, where some of the illustrated terms will be omitted if the lengths of
\code{a} and \code{b} are too small, and terms are dropped at the start of
the time series where the index on \code{x} would be less than 1.

By contrast with the \code{\link[=filter]{filter()}} function of R, \code{oce.filter}
lacks the option to do a circular filter.  As a consequence,
\code{oceFilter} introduces a phase lag.  One way to remove this lag is to
run the filter forwards and then backwards, as in the \dQuote{Examples}.
However, the result is still problematic, in the sense that applying it in
the reverse order would yield a different result.  (Matlab's \code{filtfilt}
shares this problem.)
}
\note{
The first value in the \code{a} vector is ignored, and if
\code{length(a)} equals 1, a non-recursive filter results.
}
\examples{
library(oce)
par(mar=c(4, 4, 1, 1))
b <- rep(1, 5)/5
a <- 1
x <- seq(0, 10)
y <- ifelse(x == 5, 1, 0)
f1 <- oceFilter(y, a, b)
plot(x, y, ylim=c(-0, 1.5), pch="o", type="b")
points(x, f1, pch="x", col="red")

# remove the phase lag
f2 <- oceFilter(y, a, b, TRUE)
points(x, f2, pch="+", col="blue")

legend("topleft", col=c("black","red","blue"), pch=c("o","x","+"),
       legend=c("data","normal filter", "zero-phase filter"))
mtext("note that normal filter rolls off at end")
}
\author{
Dan Kelley
}
