% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odf.R
\name{subset,odf-method}
\alias{subset,odf-method}
\title{Subset an odf Object}
\usage{
\S4method{subset}{odf}(x, subset, ...)
}
\arguments{
\item{x}{an \linkS4class{odf} object.}

\item{subset}{a condition to be applied to the \code{data} portion of
\code{x}.  See \dQuote{Details}.}

\item{\dots}{ignored.}
}
\value{
An \linkS4class{odf} object.
}
\description{
This function is somewhat analogous to \code{\link[=subset.data.frame]{subset.data.frame()}}.
}
\details{
It seems likely that users will first convert the odf object into
another class (e.g. ctd) and use the subset method of that class;
note that some of those methods interpret the \dots argument.
}
\seealso{
Other things related to odf data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{ODF2oce}()},
\code{\link{ODFListFromHeader}()},
\code{\link{ODFNames2oceNames}()},
\code{\link{[[,odf-method}},
\code{\link{[[<-,odf-method}},
\code{\link{odf-class}},
\code{\link{plot,odf-method}},
\code{\link{read.ctd.odf}()},
\code{\link{read.odf}()},
\code{\link{summary,odf-method}}

Other functions that subset oce objects: 
\code{\link{subset,adp-method}},
\code{\link{subset,adv-method}},
\code{\link{subset,amsr-method}},
\code{\link{subset,argo-method}},
\code{\link{subset,cm-method}},
\code{\link{subset,coastline-method}},
\code{\link{subset,ctd-method}},
\code{\link{subset,echosounder-method}},
\code{\link{subset,lobo-method}},
\code{\link{subset,met-method}},
\code{\link{subset,oce-method}},
\code{\link{subset,rsk-method}},
\code{\link{subset,sealevel-method}},
\code{\link{subset,section-method}},
\code{\link{subset,topo-method}},
\code{\link{subset,xbt-method}}
}
\author{
Dan Kelley
}
\concept{functions that subset oce objects}
\concept{things related to odf data}
