% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_source.R
\name{add_source}
\alias{add_source}
\title{Add a source on a 'leaflet' map}
\usage{
add_source(map, source)
}
\arguments{
\item{map}{objet leaflet.}

\item{source}{chaine de caracteres (character). Source de la carte.}
}
\value{
Retourne un objet de type leaflet.
}
\description{
Add a source on a 'leaflet' map
}
\details{
Pour supprimer la source, reexecutez la fonction add_source en laissant le
parametre \code{source} a NULL.
}
\examples{

data("donnees_monoloc")
data("depm")

# Ronds proportionnels
map <- leaflet_ronds(data = donnees_monoloc, fondMaille = depm, idData = "COD_DEP",
varVolume = "POP_2015")
map <- add_source(map = map, source = "Source : INSEE - RP2016")
\donttest{
 map
}

}
\seealso{
\code{\link{leaflet_ronds}, \link{leaflet_classes},
\link{leaflet_ronds_classes}, \link{leaflet_classes_ronds},
\link{leaflet_typo},}

\code{\link{leaflet_oursins}, \link{leaflet_joignantes},
\link{leaflet_saphirs}}
}
\keyword{documentation}
