% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.3.R
\name{power.3}
\alias{power.3}
\title{Budget and/or sample size, power, MDES calculation for
three-level CRTs detecting main effects}
\usage{
power.3(
  cost.model = TRUE,
  expr = NULL,
  constraint = NULL,
  sig.level = 0.05,
  two.tailed = TRUE,
  d = NULL,
  power = NULL,
  m = NULL,
  n = NULL,
  J = NULL,
  K = NULL,
  p = NULL,
  icc2 = NULL,
  icc3 = NULL,
  r12 = NULL,
  r22 = NULL,
  r32 = NULL,
  q = NULL,
  c1 = NULL,
  c2 = NULL,
  c3 = NULL,
  c1t = NULL,
  c2t = NULL,
  c3t = NULL,
  dlim = NULL,
  powerlim = NULL,
  Klim = NULL,
  mlim = NULL,
  rounded = TRUE
)
}
\arguments{
\item{cost.model}{Logical; power analyses accommodating costs and budget
(e.g., required budget for desired power, power/MDES under fixed budget)
if TRUE, otherwise conventional power analyses
(e.g., required sample size, power, or MDES calculation); default value is TRUE.}

\item{expr}{Returned objects from function \code{\link{od.3}}; default is NULL;
if \code{expr} is specified, parameter values of \code{icc2}, \code{icc3},
\code{r12}, \code{r22}, \code{r32},
\code{c1}, \code{c2}, \code{c3}, \code{c1t}, \code{c2t}, \code{c3t},
\code{p}, \code{n}, and \code{J}
used or solved in function \code{\link{od.3}} will
be passed to the current function;
only the values of \code{p}, \code{n}, and/or \code{J} that specified or solved in
function \code{\link{od.3}} can be overwritten
if \code{constraint} is specified.}

\item{constraint}{Specify the constrained values of \code{p}, \code{n},
and/or \code{J} in list format to overwrite those
from \code{expr}; default is NULL.}

\item{sig.level}{Significance level or type I error rate, default value is 0.05.}

\item{two.tailed}{Logical; two-tailed tests if TRUE,
otherwise one-tailed tests; default value is TRUE.}

\item{d}{Effect size.}

\item{power}{Statistical power.}

\item{m}{Total budget.}

\item{n}{The level-1 sample size per level-2 unit.}

\item{J}{The level-2 sample size per level-3 unit.}

\item{K}{The total level-3 sample size.}

\item{p}{The proportion of level-3 clusters/units assigned to treatment.}

\item{icc2}{The unconditional intraclass correlation coefficient (ICC) at level 2.}

\item{icc3}{The unconditional intraclass correlation coefficient (ICC) at level 3.}

\item{r12}{The proportion of level-1 variance explained by covariates.}

\item{r22}{The proportion of level-2 variance explained by covariates.}

\item{r32}{The proportion of level-3 variance explained by covariates.}

\item{q}{The number of covariates at level 3.}

\item{c1}{The cost of sampling one level-1 unit in control condition.}

\item{c2}{The cost of sampling one level-2 unit in control condition.}

\item{c3}{The cost of sampling one level-3 unit in control condition.}

\item{c1t}{The cost of sampling one level-1 unit in treatment condition.}

\item{c2t}{The cost of sampling one level-2 unit in treatment condition.}

\item{c3t}{The cost of sampling one level-3 unit in treatment condition.}

\item{dlim}{The range for searching the root of effect size (\code{d}) numerically,
default value is c(0, 5).}

\item{powerlim}{The range for searching the root of power (\code{power}) numerically,
default value is c(1e-10, 1 - 1e-10).}

\item{Klim}{The range for searching the root of level-3 sample size (\code{K}) numerically,
default value is c(4, 1e+10).}

\item{mlim}{The range for searching the root of budget (\code{m}) numerically,
default value is the costs sampling \code{Klim} level-3 units across treatment conditions
or c(4 * Kcost, 1e+10 * Kcost) with Kcost =
((1 - p) * (c1 * n * J + c2 * J + c3) + p * (c1t * n * J + c2t * J + c3t)).}

\item{rounded}{Logical; round the values of \code{p}, \code{n}/\code{J} that are
from functions \code{\link{od.3}}
to two decimal places and integer, respectively if TRUE,
otherwise no rounding; default value is TRUE.}
}
\value{
Required budget (and/or required level-3 sample size), statistical power, or MDES
    depending on the specification of parameters.
    The function also returns the function name, design type,
    and parameters used in the calculation.
}
\description{
This function can calculate required budget for desired power,
    power or minimum detectable effect size (MDES) under fixed budget
    for three-level cluster randomized trials (CRTs).
    It also can perform conventional power analyses
    (e.g., required sample size, power, and MDES calculation).
}
\examples{
# Unconstrained optimal design
  myod1 <- od.3(icc2 = 0.2, icc3 = 0.1, r12 = 0.5, r22 = 0.5, r32 = 0.5,
              c1 = 1, c2 = 5, c3 = 25, c1t = 1, c2t = 50, c3t = 250)
  myod1$out # output  # n = 7.9, J = 3.2, p = 0.28

# ------- Power analyses by default considering costs and budget -------
# Required budget and sample size
  mym.1 <- power.3(expr = myod1, d = 0.2, q = 1, power = 0.8)
  mym.1$out  # m = 16032, K = 97.3
  #mym.1$par  # parameters and their values used for the function
# Or, equivalently, specify every argument in the function
  mym.1 <- power.3(d = 0.2, power = 0.8, q = 1,
                 icc2 = 0.2, icc3 = 0.1, r12 = 0.5, r22 = 0.5, r32 = 0.5,
                 c1 = 1, c2 = 5, c3 = 25, c1t = 1, c2t = 50, c3t = 250,
                 n = 8, J = 3, p = 0.28)
# Required budget and sample size with constrained p
  mym.2 <- power.3(expr = myod1, d = 0.2, q = 1, power = 0.8,
                 constraint = list(p = 0.5))
  mym.2$out  # m = 19239, K = 78.8
# Required budget and sample size with constrained p and J
  mym.3 <- power.3(expr = myod1, d = 0.2, q = 1, power = 0.8,
                 constraint = list(p = 0.5, J = 20))
  mym.3$out  # m = 39774, K = 46.9

# Power calculation
  mypower <- power.3(expr = myod1, q = 1, d = 0.2, m = 16032)
  mypower$out  # power = 0.80
# Power calculation under constrained p (p = 0.5)
  mypower.1 <- power.3(expr = myod1, q = 1, d = 0.2, m = 16032,
                 constraint = list(p = 0.5))
  mypower.1$out  # power = 0.72

# MDES calculation
  mymdes <- power.3(expr = myod1, q = 1, power = 0.80, m = 16032)
  mymdes$out  # d = 0.20


# ------- Conventional power analyses with cost.model = FALSE-------
# Required sample size
  myK <- power.3(cost.model = FALSE, expr = myod1, d = 0.2, q = 1, power = 0.8)
  myK$out  # K = 97.3
  #myK$par  # parameters and their values used for the function
# Or, equivalently, specify every argument in the function
  myK <- power.3(cost.model = FALSE, d = 0.2, power = 0.8, q = 1,
                  icc2 = 0.2, icc3 = 0.1, r12 = 0.5, r22 = 0.5, r32 = 0.5,
                  n = 8, J = 3, p = 0.28)

# Power calculation
  mypower1 <- power.3(cost.model = FALSE, expr = myod1, K = 97, d = 0.2, q = 1)
  mypower1$out  # power = 0.80

# MDES calculation
  mymdes1 <- power.3(cost.model = FALSE, expr = myod1, K = 97, power = 0.8, q = 1)
  mymdes1$out  # d = 0.20

}
\references{
Shen, Z., & Kelcey, B. (2020). Optimal sample allocation under unequal
  costs in cluster-randomized trials. Journal of Educational
  and Behavioral Statistics, 45(4): 446–474.
   <https://doi.org/10.3102/1076998620912418>
}
