% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timed_evaluation.R
\name{timed}
\alias{timed}
\title{Interrupt long evaluations}
\usage{
timed(expression, seconds = Inf)
}
\arguments{
\item{expression}{An R expression to be evaluated.}

\item{seconds}{The number of seconds.}
}
\value{
Either the value of \code{expression} or \code{NULL} if the evaluation time
exceeded \code{seconds} seconds.
}
\description{
This function interrupts an evaluation after a certain number of seconds.
}
\details{
This function is a wrapper for \code{\link[R.utils]{withTimeout}}.
}
\examples{
\dontrun{
foo <- function(x) { for(i in 1:10) Sys.sleep(x/10); return(x) }
timed(foo(0.5), 1)
timed(foo(1.5), 1)
}

}
