% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_density.R
\name{ddirichlet}
\alias{ddirichlet}
\title{Compute density of Dirichlet distribution}
\usage{
ddirichlet(x, concentration, log = FALSE)
}
\arguments{
\item{x}{A \code{numeric}, a weight vector of length \code{p}.
Each vector element must be between \code{0} and \code{1}.
The sum of the vector elements must be \code{1}.}

\item{concentration}{A \code{numeric}, the concentration vector of length \code{p}.}

\item{log}{A \code{logical}, if \code{TRUE} the logarithm of the density value is
returned.
By default, \code{log = FALSE}.}
}
\value{
A \code{numeric}, the density value.
}
\description{
This function computes the density of a Dirichlet distribution.
}
\examples{
x <- c(0.5, 0.3, 0.2)
concentration <- 1:3
ddirichlet(x = x, concentration = concentration)
ddirichlet(x = x, concentration = concentration, log = TRUE)

}
