% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_matrix.R
\name{print_matrix}
\alias{print_matrix}
\title{Print (abbreviated) \code{matrix}}
\usage{
print_matrix(
  x,
  rowdots = 4,
  coldots = 4,
  digits = 2,
  label = NULL,
  simplify = FALSE,
  details = !simplify
)
}
\arguments{
\item{x}{[\code{atomic()} | \code{matrix}]\cr
The object to be printed.}

\item{rowdots}{[\code{integer(1)}]\cr
The row number which is replaced by \code{...}.}

\item{coldots}{[\code{integer(1)}]\cr
The column number which is replaced by \code{...}.}

\item{digits}{[\code{integer(1)}]\cr
The number of printed decimal places if input \code{x} is \code{numeric}.}

\item{label}{[\code{character(1)}]\cr
A label for \code{x}. Only printed if \code{simplify = FALSE}.}

\item{simplify}{[\code{logical(1)}]\cr
Simplify the output?}

\item{details}{[\code{logical(1)}]\cr
Print the type and dimension of \code{x}?}
}
\value{
Invisibly returns \code{x}.
}
\description{
This function prints a (possibly abbreviated) \code{matrix}.
}
\examples{
print_matrix(x = 1, label = "single numeric")
print_matrix(x = LETTERS[1:26], label = "letters")
print_matrix(x = 1:3, coldots = 2)
print_matrix(x = matrix(rnorm(99), ncol = 1), label = "single column matrix")
print_matrix(x = matrix(1:100, nrow = 1), label = "single row matrix")
print_matrix(x = matrix(LETTERS[1:24], ncol = 6), label = "big matrix")
print_matrix(x = diag(5), coldots = 2, rowdots = 2, simplify = TRUE)
}
\references{
This function is a modified version of \code{ramify::pprint()}.
}
\seealso{
Other package helpers: 
\code{\link{Dictionary}},
\code{\link{Storage}},
\code{\link{identical_structure}()},
\code{\link{input_check_response}()},
\code{\link{match_arg}()},
\code{\link{package_logo}()},
\code{\link{print_data.frame}()},
\code{\link{system_information}()},
\code{\link{unexpected_error}()},
\code{\link{user_confirm}()}
}
\concept{package helpers}
\keyword{packaging}
