% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_add_img}
\alias{body_add_img}
\title{add image}
\usage{
body_add_img(
  x,
  src,
  style = NULL,
  width,
  height,
  units = c("in", "cm", "mm"),
  pos = "after"
)
}
\arguments{
\item{x}{an rdocx object}

\item{src}{image filename, the basename of the file must not contain any blank.}

\item{style}{paragraph style}

\item{width}{height in units}

\item{height}{height in units}

\item{units}{one of c("in", "cm", "mm")}

\item{pos}{where to add the new element relative to the cursor,
one of "after", "before", "on".}
}
\description{
add an image into an rdocx object.
}
\examples{
doc <- read_docx()

img.file <- file.path( R.home("doc"), "html", "logo.jpg" )
if( file.exists(img.file) ){
  doc <- body_add_img(x = doc, src = img.file, height = 1.06, width = 1.39 )
}

print(doc, target = tempfile(fileext = ".docx"))
}
\seealso{
Other functions for adding content: 
\code{\link{body_add_blocks}()},
\code{\link{body_add_break}()},
\code{\link{body_add_docx}()},
\code{\link{body_add_fpar}()},
\code{\link{body_add_gg}()},
\code{\link{body_add_par}()},
\code{\link{body_add_table}()},
\code{\link{body_add_toc}()}
}
\concept{functions for adding content}
