% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_run_objects.R
\name{run_autonum}
\alias{run_autonum}
\title{auto number}
\usage{
run_autonum(
  seq_id = "table",
  pre_label = "Table ",
  post_label = ": ",
  bkm = NULL,
  bkm_all = FALSE,
  prop = NULL
)
}
\arguments{
\item{seq_id}{sequence identifier}

\item{pre_label, post_label}{text to add before and after number}

\item{bkm}{bookmark id to associate with autonumber run. If NULL, no bookmark
is added. Value can only be made of alpha numeric characters, '-' and '_'.}

\item{bkm_all}{if TRUE, the bookmark will be set on the whole string, if
FALSE, the bookmark will be set on the number only. Default to FALSE.
As an effect when a reference to this bookmark is used, the text can
be like "Table 1" or "1" (pre_label is not included in the referenced
text).}

\item{prop}{formatting text properties returned by \link{fp_text}.}
}
\description{
Create an autonumbered chunk, i.e. a string
representation of a sequence, each item will be numbered.
These runs can also be bookmarked and be used later for
cross references.
}
\section{usage}{

You can use this function in conjunction with \link{fpar} to create paragraphs
consisting of differently formatted text parts. You can also use this
function as an \emph{r chunk} in an R Markdown document made with package
officedown.
}

\examples{
run_autonum()
run_autonum(seq_id = "fig", pre_label = "fig. ")
run_autonum(seq_id = "tab", pre_label = "Table ", bkm = "anytable")
}
\seealso{
Other run functions for reporting: 
\code{\link{external_img}()},
\code{\link{ftext}()},
\code{\link{hyperlink_ftext}()},
\code{\link{run_bookmark}()},
\code{\link{run_columnbreak}()},
\code{\link{run_linebreak}()},
\code{\link{run_pagebreak}()},
\code{\link{run_reference}()},
\code{\link{run_word_field}()}

Other Word computed fields: 
\code{\link{run_reference}()},
\code{\link{run_word_field}()}
}
\concept{Word computed fields}
\concept{run functions for reporting}
