% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sim_slcm}
\alias{sim_slcm}
\title{Simulate Ordinal Item Data from a Sparse Latent Class Model}
\usage{
sim_slcm(N, J, M, nClass, CLASS, Atable, BETA, KAPPA)
}
\arguments{
\item{N}{Number of Observations}

\item{J}{Number of Items}

\item{M}{Number of Item Categories (2, 3,  ..., M)}

\item{nClass}{Number of Latent Classes}

\item{CLASS}{A vector of \eqn{N} observations containing the class ID of the
subject.}

\item{Atable}{A matrix of dimensions \eqn{M^K \times M^O} containing
the attribute classes in bijection-form. Note, \eqn{O} refers
to the model's highest interaction order.}

\item{BETA}{A matrix of dimensions \eqn{J \times M^K} containing the
coefficients of the reparameterized \eqn{\beta} matrix.}

\item{KAPPA}{A matrix of dimensions \eqn{J \times M} containing the
category threshold parameters}
}
\value{
An ordinal item matrix of dimensions \eqn{N \times J}{N x J} with \eqn{M}
response levels.
}
\description{
Simulate Ordinal Item Data from a Sparse Latent Class Model
}
\seealso{
\link{ohoegdm}
}
