% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oiisummary.R
\name{oii.summary}
\alias{oii.summary}
\title{Print summary statistics for a numeric variable}
\usage{
oii.summary(x, extended = FALSE, warnings = FALSE)
}
\arguments{
\item{x}{a numeric vector for which summary statistics should be generated.}

\item{extended}{a logical value indicating whether additional statistics should be printed (see Value section). Defaults to FALSE
stripped before the computation proceeds (defaults to TRUE).}

\item{warnings}{a logical value indicating whether warnings should be shown (defaults to FALSE, no warnings).}
}
\value{
If \code{x} is not numeric, the built-in summary command is executed. 
If \code{x} is numeric (that is, \code{is.numeric(x)} returns TRUE), then a list with the following elements is returned:
  \item{cases}{The number of non-missing values in \code{x} (Valid N)}
  \item{na}{The number of missing values in \code{x} (Missing N).}
  \item{mean}{The mean value of \code{x} after missing values are removed. See \code{\link{mean}}}
  \item{sd}{The standard deviation for values in \code{x}. See \code{\link{sd}}}
  \item{min}{The minimum/smallest value in \code{x}. See \code{\link{min}}}
  \item{max}{The maximum/largest value in \code{x}. See \code{\link{max}}}
{}
This function also calculates the following statistics, but these are not printed by default unless extended is set to TRUE
  \item{var}{The variance of \code{x} after missing values are removed. See \code{\link{var}}}
  \item{median}{The median value of \code{x} after missing values are removed. See \code{\link{median}}}
  \item{p25}{The 25th percentile of \code{x} after missing values are removed}
  \item{p75}{The 75th percentile of \code{x} after missing values are removed}
  \item{skewness}{The skewness coefficient for \code{x} after missing values are removed. See \code{\link[rapportools]{skewness}}}
  \item{kurtosis}{The kurtosis coefficient for \code{x} after missing values are removed. See \code{\link[rapportools]{kurtosis}}}
}
\description{
This function is designed to be like the built-in \code{\link{summary}}
function but include a few additional values.
If the input is not numeric, the built-in summary command is executed.
}
\examples{

#Generate data from a normal distribution with mean 0 and sd 1
#store the result in a variable called tmp
tmp<-rnorm(500,mean=0,sd=1)

#Print the summary statistics about tmp
oii.summary(tmp)
#Print even more summary statistics about tmp
oii.summary(tmp,extended=TRUE)
}
\seealso{
\code{\link{summary}}, \code{\link{min}}, \code{\link{median}}, \code{\link{mean}}, \code{\link{max}}, \code{\link{sd}},
\code{\link{is.na}}, \code{\link{is.numeric}}, \code{\link[rapportools]{skewness}}, \code{\link[rapportools]{kurtosis}}, \code{\link{var}}
}

