% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-information-criteria.R
\name{ols_hsp}
\alias{ols_hsp}
\title{Hocking's Sp}
\usage{
ols_hsp(model)
}
\arguments{
\item{model}{an object of class \code{lm}}
}
\value{
Hocking's Sp
}
\description{
Average prediction mean squared error
}
\details{
Hocking's Sp criterion is an adjustment of the residual sum of Squares. Minimize this criterion.

\deqn{MSE / (n - p - 1)}

where \eqn{MSE = SSE / (n - p)}, n is the sample size and p is the number of predictors including the intercept
}
\examples{
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_hsp(model)
}
\references{
Hocking, R. R. (1976). “The Analysis and Selection of Variables in a Linear Regression.” Biometrics
32:1–50.
}

