% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeLists.r
\name{mergeLists}
\alias{mergeLists}
\title{Merge two lists with precedence}
\usage{
mergeLists(...)
}
\arguments{
\item{...}{Two or more lists.}
}
\value{
A list.
}
\description{
This function merges two or more lists to create a single, combined list. If two elements in different lists have the same name, items in the later list gain preference (e.g., if there are three lists, then values in the third list gain precedence over items with the same name in the second, and the second has precedence over items in the first).
}
\examples{

list1 <- list(a=1:3, b='Hello world!', c=LETTERS[1:3])
list2 <- list(x=4, b='Goodbye world!', z=letters[1:2])
list3 <- list(x=44, b='What up, world?', z=c('_A_', '_Z_'), w = TRUE)

mergeLists(list1, list2)
mergeLists(list2, list1)

mergeLists(list1, list2, list3)
mergeLists(list3, list2, list1)

}
\seealso{
\code{\link{appendLists}}
}
