% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearFromDate.r
\name{yearFromDate}
\alias{yearFromDate}
\title{Year from date formats that are possibly ambiguous}
\usage{
yearFromDate(x, yearLast = TRUE)
}
\arguments{
\item{x}{Character or character vector, one or more dates.}

\item{yearLast}{Logical, if \code{TRUE} assume that dates like "XX/YY/ZZ" list the year last (=ZZ).  If \code{FALSE}, assume they're first (=XX).}
}
\value{
Numeric.
}
\description{
This function attempts to return the year from characters representing dates formats. The formats can be ambigous and varied within the same set.  For example, it returns "1982" (or 9982 if century is ambiguous) from "11/20/82", "1982-11-20", "Nov. 20, 1982", "20 Nov 1982", "20-Nov-1982", "20/Nov/1982", "20 Nov. 82", "20 Nov 82". The function handles ambiguous centuries (e.g., 1813, 1913, 2013) by including a dummy place holder for the century place (i.e., 9913). Note that it may return warnings like "NAs introduced by coercion".
}
\examples{
yearFromDate(1969, yearLast=TRUE)
yearFromDate('10-Jul-71', yearLast=TRUE) # --> 9971
yearFromDate('10-Jul-1971', yearLast=TRUE) # --> 1971
yearFromDate('10-19-71', yearLast=TRUE) # --> 9971
yearFromDate('10-19-1969', yearLast=TRUE) # --> 1969
yearFromDate('10-1-71', yearLast=TRUE) # --> 9971
yearFromDate('3-22-71', yearLast=TRUE) # --> 9971
yearFromDate('3-2-71', yearLast=TRUE) # --> 9971
yearFromDate('10-1-1969', yearLast=TRUE) # --> 1969
yearFromDate('3-22-1969', yearLast=TRUE) # --> 1969
yearFromDate('3-2-1969', yearLast=TRUE) # --> 1969
yearFromDate('10/Jul/71', yearLast=TRUE) # --> 9971
yearFromDate('10/Jul/1971', yearLast=TRUE) # --> 1971
yearFromDate('10/19/71', yearLast=TRUE) # --> 9971
yearFromDate('10/19/1969', yearLast=TRUE) # --> 1969
yearFromDate('10/1/71', yearLast=TRUE) # --> 9971
yearFromDate('3/22/71', yearLast=TRUE) # --> 9971
yearFromDate('3/2/71', yearLast=TRUE) # --> 9971
yearFromDate('10/1/1969', yearLast=TRUE) # --> 1969
yearFromDate('3/22/1969', yearLast=TRUE) # --> 1969
yearFromDate('3/2/1969', yearLast=TRUE) # --> 1969
yearFromDate('10 mmm 71', yearLast=TRUE) # "mmm" is month abbreviation--> 9971
yearFromDate('5 mmm 71', yearLast=TRUE) # "mmm" is month abbreviation--> 9971
yearFromDate('10 19 71', yearLast=TRUE) # --> 9971
yearFromDate('10 19 1969', yearLast=TRUE) # --> 1969
yearFromDate('10 1 71', yearLast=TRUE) # --> 9971
yearFromDate('3 22 71', yearLast=TRUE) # --> 9971
yearFromDate('3 2 71', yearLast=TRUE) # --> 9971
yearFromDate('10 1 1969', yearLast=TRUE) # --> 1969
yearFromDate('3 22 1969', yearLast=TRUE) # --> 1969
yearFromDate('3 2 1969', yearLast=TRUE) # --> 1969
yearFromDate('Oct. 19, 1969', yearLast=TRUE) # --> 1969
yearFromDate('19 October 1969', yearLast=TRUE) # --> 1969
yearFromDate('How you do dat?', yearLast=TRUE) # --> NA
yearFromDate('2014-07-03', yearLast=TRUE) # --> 2014
yearFromDate('2014-7-03', yearLast=TRUE) # --> 2014
yearFromDate('2014-07-3', yearLast=TRUE) # --> 2014
yearFromDate('2014-7-3', yearLast=TRUE) # --> 2014
yearFromDate('2014/07/03', yearLast=TRUE) # --> 2014
yearFromDate('2014/7/03', yearLast=TRUE) # --> 2014
yearFromDate('2014/07/3', yearLast=TRUE) # --> 2014
yearFromDate('2014/7/3', yearLast=TRUE) # --> 2014
yearFromDate('2014 07 03', yearLast=TRUE) # --> 2014
yearFromDate('2014 7 03', yearLast=TRUE) # --> 2014
yearFromDate('2014 07 3', yearLast=TRUE) # --> 2014
yearFromDate('2014 7 3', yearLast=TRUE) # --> 2014

yearFromDate(1969, yearLast=FALSE)
yearFromDate('10-Jul-71', yearLast=FALSE) # --> 9971
yearFromDate('10-Jul-1971', yearLast=FALSE) # --> 1971
yearFromDate('10-19-71', yearLast=FALSE) # --> 9910
yearFromDate('10-19-1969', yearLast=FALSE) # --> 1969
yearFromDate('10-1-71', yearLast=FALSE) # --> 9910
yearFromDate('3-22-71', yearLast=FALSE) # --> 9971
yearFromDate('3-2-71', yearLast=FALSE) # --> 9971
yearFromDate('10-1-1969', yearLast=FALSE) # --> 1969
yearFromDate('3-22-1969', yearLast=FALSE) # --> 1969
yearFromDate('3-2-1969', yearLast=FALSE) # --> 1969
yearFromDate('10/19/71', yearLast=FALSE) # --> 9910
yearFromDate('10/19/1969', yearLast=FALSE) # --> 1969
yearFromDate('10/1/71', yearLast=FALSE) # --> 9910
yearFromDate('3/22/71', yearLast=FALSE) # --> 9971
yearFromDate('3/2/71', yearLast=FALSE) # --> 9971
yearFromDate('10/1/1969', yearLast=FALSE) # --> 1969
yearFromDate('3/22/1969', yearLast=FALSE) # --> 1969
yearFromDate('3/2/1969', yearLast=FALSE) # --> 1969
yearFromDate('10 mmm 71', yearLast=FALSE) # "mmm" is month abbreviation--> 9971
yearFromDate('5 mmm 71', yearLast=FALSE) # "mmm" is month abbreviation--> 9971
yearFromDate('10 19 71', yearLast=FALSE) # --> 9910
yearFromDate('10 19 1969', yearLast=FALSE) # --> 1969
yearFromDate('10 1 71', yearLast=FALSE) # --> 9910
yearFromDate('3 22 71', yearLast=FALSE) # --> 9971
yearFromDate('3 2 71', yearLast=FALSE) # --> 9971
yearFromDate('10 1 1969', yearLast=FALSE) # --> 1969
yearFromDate('3 22 1969', yearLast=FALSE) # --> 1969
yearFromDate('3 2 1969', yearLast=FALSE) # --> 1969
yearFromDate('Oct. 19, 1969', yearLast=FALSE) # --> 1969
yearFromDate('19 October 1969', yearLast=FALSE) # --> 1969
yearFromDate('How you do dat?', yearLast=FALSE) # --> NA
yearFromDate('2014-07-03', yearLast=FALSE) # --> 2014
yearFromDate('2014-7-03', yearLast=FALSE) # --> 2014
yearFromDate('2014-07-3', yearLast=FALSE) # --> 2014
yearFromDate('2014-7-3', yearLast=FALSE) # --> 2014
yearFromDate('2014/07/03', yearLast=FALSE) # --> 2014
yearFromDate('2014/7/03', yearLast=FALSE) # --> 2014
yearFromDate('2014/07/3', yearLast=FALSE) # --> 2014
yearFromDate('2014/7/3', yearLast=FALSE) # --> 2014
yearFromDate('2014 07 03', yearLast=FALSE) # --> 2014
yearFromDate('2014 7 03', yearLast=FALSE) # --> 2014
yearFromDate('2014 07 3', yearLast=FALSE) # --> 2014
yearFromDate('2014 7 3', yearLast=FALSE) # --> 2014
}
