% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_seq.R
\name{make_seq}
\alias{make_seq}
\title{Create a sequence of markers based on other OneMap object types}
\usage{
make_seq(input.obj, arg = NULL, phase = NULL, data.name = NULL, twopt = NULL)
}
\arguments{
\item{input.obj}{an object of class \code{onemap}, \code{rf_2pts},
\code{group}, \code{compare}, \code{try} or \code{order}.}

\item{arg}{its value depends on the type of object \code{input.obj}. For
a \code{onemap} object, \code{arg} must be a string corresponding to one
of the reference sequences on which markers are anchored (usually
chromosomes). This requires that \code{CHROM} information be available in
the input data file. It can also be a \code{vector} of integers specifying
which markers comprise the sequence. For an object \code{rf_2pts},
\code{arg} can be the string "all", resulting in a sequence with all
markers in the raw data (generally done for grouping markers); otherwise,
it must be a \code{vector} of integers specifying which markers comprise
the sequence. For an object of class \code{group}, \code{arg} must be an
integer specifying the group. For a \code{compare} object, \code{arg} is
an integer indicating the corresponding order (arranged according to the
likelihood); if \code{NULL} (default), the best order is taken. For an
object of class \code{try}, \code{arg} must be an integer less than or
equal to the length of the original sequence plus one; the sequence
obtained will be that with the additional marker in the position indicated
by \code{arg}.  Finally, for an \code{order} object, \code{arg} is a
string: "safe" means the order that contains only markers mapped with the
provided threshold; "force" means the order with all markers.}

\item{phase}{its value is also dependent on the type of \code{input.obj}.
For an \code{rf_2pts} or \code{onemap} object, \code{phase} can be a
\code{vector} with user- defined linkage phases (its length is equal to the
number of markers minus one); if \code{NULL} (default), other functions will
try to find the best linkage phases. For example, if \code{phase} takes on
the vector \code{c(1,2,3,4)}, the sequence of linkage phases will be
coupling/coupling, coupling/repulsion, repulsion/coupling and
repulsion/repulsion for a sequence of five markers. If \code{input.obj} is
of class \code{compare} or \code{try}, this argument indicates which
combination of linkage phases should be chosen, for the particular order
given by argument \code{arg}. In both cases, \code{NULL} (default) makes the
best combination to be taken. If \code{input.obj} is of class, \code{group}, 
\code{group.upgma} or \code{order}, this argument has no effect.}

\item{data.name}{the object which
contains the raw data. This does not have to be defined by the
user: it is here for compatibility issues when calling \code{make_seq} from
inside other functions.}

\item{twopt}{the object which
contains the two-point information. This does not have to be defined by the
user: it is here for compatibility issues when calling \code{make_seq} from
inside other functions.}
}
\value{
An object of class \code{sequence}, which is a list containing the
following components: \item{seq.num}{a \code{vector} containing the
(ordered) indices of markers in the sequence, according to the input file.}
\item{seq.phases}{a \code{vector} with the linkage phases between markers
in the sequence, in corresponding positions. \code{-1} means that there are
no defined linkage phases.} \item{seq.rf}{a \code{vector} with the
recombination frequencies between markers in the sequence. \code{-1} means
that there are no estimated recombination frequencies.}
\item{seq.like}{log-likelihood of the corresponding linkage map.}
\item{data.name}{object of class \code{onemap} with the raw
data.} \item{twopt}{object of class \code{rf_2pts} with the
2-point analyses.}
}
\description{
Makes a sequence of markers based on an object of another type.
}
\examples{

\donttest{
  data(onemap_example_out)
  twopt <- rf_2pts(onemap_example_out)

  all_mark <- make_seq(twopt,"all")
  all_mark <- make_seq(twopt,1:30) # same as above, for this data set
  groups <- group(all_mark)
  LG1 <- make_seq(groups,1)
  LG1.ord <- order_seq(LG1)
  (LG1.final <- make_seq(LG1.ord)) # safe order
  (LG1.final.all <- make_seq(LG1.ord,"force")) # forced order

  markers <- make_seq(twopt,c(2,3,12,14))
  markers.comp <- compare(markers)
  (base.map <- make_seq(markers.comp))
  base.map <- make_seq(markers.comp,1,1) # same as above
  (extend.map <- try_seq(base.map,30))
  (base.map <- make_seq(extend.map,5)) # fifth position is the best
}
}
\references{
Lander, E. S., Green, P., Abrahamson, J., Barlow, A., Daly, M.
J., Lincoln, S. E. and Newburg, L. (1987) MAPMAKER: An interactive computer
package for constructing primary genetic linkage maps of experimental and
natural populations. \emph{Genomics} 1: 174-181.
}
\seealso{
\code{\link[onemap]{compare}}, \code{\link[onemap]{try_seq}},
\code{\link[onemap]{order_seq}} and \code{\link[onemap]{map}}.
}
\author{
Gabriel Margarido, \email{gramarga@gmail.com}
}
\keyword{utilities}
