% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_dataset_bins.R
\name{add_redundants}
\alias{add_redundants}
\title{Add the redundant markers removed by create_data_bins function}
\usage{
add_redundants(sequence, onemap.obj, bins)
}
\arguments{
\item{sequence}{object of class \code{sequence}}

\item{onemap.obj}{object of class \code{onemap.obj} before redundant markers were removed}

\item{bins}{object of class \code{onemap_bin}}
}
\value{
New sequence object of class \code{sequence}, which is a list containing the
following components: \item{seq.num}{a \code{vector} containing the
(ordered) indices of markers in the sequence, according to the input file.}
\item{seq.phases}{a \code{vector} with the linkage phases between markers
in the sequence, in corresponding positions. \code{-1} means that there are
no defined linkage phases.} \item{seq.rf}{a \code{vector} with the
recombination frequencies between markers in the sequence. \code{-1} means
that there are no estimated recombination frequencies.}
\item{seq.like}{log-likelihood of the corresponding linkage map.}
\item{data.name}{object of class \code{onemap} with the raw
data.} \item{twopt}{object of class \code{rf_2pts} with the
2-point analyses.}
}
\description{
Add the redundant markers removed by create_data_bins function
}
\seealso{
\code{\link[onemap]{find_bins}}
}
\author{
Cristiane Taniguti, \email{chtaniguti@tamu.edu}
}
\keyword{bins}
\keyword{redundants}
